package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.SearchPaginationTokenType
import scala.jdk.CollectionConverters._
final case class ListDevicesResponse(
    devices: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.DeviceType]
    ] = None,
    paginationToken: Option[SearchPaginationTokenType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse = {
    import ListDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse
      .builder()
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        paginationToken.map(value =>
          SearchPaginationTokenType.unwrap(value): java.lang.String
        )
      )(_.paginationToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListDevicesResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListDevicesResponse
      .wrap(buildAwsValue())
}
object ListDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ListDevicesResponse =
      zio.aws.cognitoidentityprovider.model.ListDevicesResponse(
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        paginationToken.map(value => value)
      )
    def devices: Option[
      List[zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly]
    ]
    def paginationToken: Option[SearchPaginationTokenType]
    def getDevices: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly
    ]] = AwsError.unwrapOptionField("devices", devices)
    def getPaginationToken: ZIO[Any, AwsError, SearchPaginationTokenType] =
      AwsError.unwrapOptionField("paginationToken", paginationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse
  ) extends zio.aws.cognitoidentityprovider.model.ListDevicesResponse.ReadOnly {
    override val devices: Option[
      List[zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly]
    ] = scala
      .Option(impl.devices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.DeviceType.wrap(item)
        }.toList
      )
    override val paginationToken: Option[SearchPaginationTokenType] = scala
      .Option(impl.paginationToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .SearchPaginationTokenType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse
  ): zio.aws.cognitoidentityprovider.model.ListDevicesResponse.ReadOnly =
    new Wrapper(impl)
}
