package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType
import scala.jdk.CollectionConverters._
final case class GetSigningCertificateRequest(userPoolId: UserPoolIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest = {
    import GetSigningCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetSigningCertificateRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetSigningCertificateRequest
      .wrap(buildAwsValue())
}
object GetSigningCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.GetSigningCertificateRequest =
      zio.aws.cognitoidentityprovider.model
        .GetSigningCertificateRequest(userPoolId)
    def userPoolId: UserPoolIdType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest
  ) extends zio.aws.cognitoidentityprovider.model.GetSigningCertificateRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest
  ): zio.aws.cognitoidentityprovider.model.GetSigningCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
