package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AdminCreateUserResponse(
    user: Option[zio.aws.cognitoidentityprovider.model.UserType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse = {
    import AdminCreateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminCreateUserResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminCreateUserResponse
      .wrap(buildAwsValue())
}
object AdminCreateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminCreateUserResponse =
      zio.aws.cognitoidentityprovider.model
        .AdminCreateUserResponse(user.map(value => value.asEditable))
    def user: Option[zio.aws.cognitoidentityprovider.model.UserType.ReadOnly]
    def getUser: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
    ] = AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse
  ) extends zio.aws.cognitoidentityprovider.model.AdminCreateUserResponse.ReadOnly {
    override val user
        : Option[zio.aws.cognitoidentityprovider.model.UserType.ReadOnly] =
      scala
        .Option(impl.user())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.UserType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse
  ): zio.aws.cognitoidentityprovider.model.AdminCreateUserResponse.ReadOnly =
    new Wrapper(impl)
}
