package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  EmailVerificationMessageType,
  SmsVerificationMessageType,
  EmailVerificationSubjectType,
  UserPoolNameType,
  TagKeysType,
  TagValueType
}
import scala.jdk.CollectionConverters._
final case class CreateUserPoolRequest(
    poolName: UserPoolNameType,
    policies: Option[zio.aws.cognitoidentityprovider.model.UserPoolPolicyType] =
      None,
    lambdaConfig: Option[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType
    ] = None,
    autoVerifiedAttributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ] = None,
    aliasAttributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.AliasAttributeType]
    ] = None,
    usernameAttributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.UsernameAttributeType]
    ] = None,
    smsVerificationMessage: Option[SmsVerificationMessageType] = None,
    emailVerificationMessage: Option[EmailVerificationMessageType] = None,
    emailVerificationSubject: Option[EmailVerificationSubjectType] = None,
    verificationMessageTemplate: Option[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType
    ] = None,
    smsAuthenticationMessage: Option[SmsVerificationMessageType] = None,
    mfaConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = None,
    deviceConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType
    ] = None,
    emailConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType
    ] = None,
    smsConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType
    ] = None,
    userPoolTags: Option[Map[TagKeysType, TagValueType]] = None,
    adminCreateUserConfig: Option[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType
    ] = None,
    schema: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.SchemaAttributeType]
    ] = None,
    userPoolAddOns: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType
    ] = None,
    usernameConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType
    ] = None,
    accountRecoverySetting: Option[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest = {
    import CreateUserPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest
      .builder()
      .poolName(UserPoolNameType.unwrap(poolName): java.lang.String)
      .optionallyWith(policies.map(value => value.buildAwsValue()))(_.policies)
      .optionallyWith(lambdaConfig.map(value => value.buildAwsValue()))(
        _.lambdaConfig
      )
      .optionallyWith(
        autoVerifiedAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.autoVerifiedAttributesWithStrings)
      .optionallyWith(
        aliasAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.aliasAttributesWithStrings)
      .optionallyWith(
        usernameAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.usernameAttributesWithStrings)
      .optionallyWith(
        smsVerificationMessage.map(value =>
          SmsVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.smsVerificationMessage)
      .optionallyWith(
        emailVerificationMessage.map(value =>
          EmailVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.emailVerificationMessage)
      .optionallyWith(
        emailVerificationSubject.map(value =>
          EmailVerificationSubjectType.unwrap(value): java.lang.String
        )
      )(_.emailVerificationSubject)
      .optionallyWith(
        verificationMessageTemplate.map(value => value.buildAwsValue())
      )(_.verificationMessageTemplate)
      .optionallyWith(
        smsAuthenticationMessage.map(value =>
          SmsVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.smsAuthenticationMessage)
      .optionallyWith(mfaConfiguration.map(value => value.unwrap))(
        _.mfaConfiguration
      )
      .optionallyWith(deviceConfiguration.map(value => value.buildAwsValue()))(
        _.deviceConfiguration
      )
      .optionallyWith(emailConfiguration.map(value => value.buildAwsValue()))(
        _.emailConfiguration
      )
      .optionallyWith(smsConfiguration.map(value => value.buildAwsValue()))(
        _.smsConfiguration
      )
      .optionallyWith(
        userPoolTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKeysType.unwrap(key): java.lang.String) -> (TagValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.userPoolTags)
      .optionallyWith(
        adminCreateUserConfig.map(value => value.buildAwsValue())
      )(_.adminCreateUserConfig)
      .optionallyWith(
        schema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schema)
      .optionallyWith(userPoolAddOns.map(value => value.buildAwsValue()))(
        _.userPoolAddOns
      )
      .optionallyWith(
        usernameConfiguration.map(value => value.buildAwsValue())
      )(_.usernameConfiguration)
      .optionallyWith(
        accountRecoverySetting.map(value => value.buildAwsValue())
      )(_.accountRecoverySetting)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CreateUserPoolRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CreateUserPoolRequest
      .wrap(buildAwsValue())
}
object CreateUserPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CreateUserPoolRequest =
      zio.aws.cognitoidentityprovider.model.CreateUserPoolRequest(
        poolName,
        policies.map(value => value.asEditable),
        lambdaConfig.map(value => value.asEditable),
        autoVerifiedAttributes.map(value => value),
        aliasAttributes.map(value => value),
        usernameAttributes.map(value => value),
        smsVerificationMessage.map(value => value),
        emailVerificationMessage.map(value => value),
        emailVerificationSubject.map(value => value),
        verificationMessageTemplate.map(value => value.asEditable),
        smsAuthenticationMessage.map(value => value),
        mfaConfiguration.map(value => value),
        deviceConfiguration.map(value => value.asEditable),
        emailConfiguration.map(value => value.asEditable),
        smsConfiguration.map(value => value.asEditable),
        userPoolTags.map(value => value),
        adminCreateUserConfig.map(value => value.asEditable),
        schema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userPoolAddOns.map(value => value.asEditable),
        usernameConfiguration.map(value => value.asEditable),
        accountRecoverySetting.map(value => value.asEditable)
      )
    def poolName: UserPoolNameType
    def policies: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ]
    def lambdaConfig: Option[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ]
    def autoVerifiedAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ]
    def aliasAttributes
        : Option[List[zio.aws.cognitoidentityprovider.model.AliasAttributeType]]
    def usernameAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.UsernameAttributeType]
    ]
    def smsVerificationMessage: Option[SmsVerificationMessageType]
    def emailVerificationMessage: Option[EmailVerificationMessageType]
    def emailVerificationSubject: Option[EmailVerificationSubjectType]
    def verificationMessageTemplate: Option[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ]
    def smsAuthenticationMessage: Option[SmsVerificationMessageType]
    def mfaConfiguration
        : Option[zio.aws.cognitoidentityprovider.model.UserPoolMfaType]
    def deviceConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ]
    def emailConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ]
    def smsConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ]
    def userPoolTags: Option[Map[TagKeysType, TagValueType]]
    def adminCreateUserConfig: Option[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ]
    def schema: Option[
      List[zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly]
    ]
    def userPoolAddOns: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ]
    def usernameConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType.ReadOnly
    ]
    def accountRecoverySetting: Option[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ]
    def getPoolName: ZIO[Any, Nothing, UserPoolNameType] = ZIO.succeed(poolName)
    def getPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ] = AwsError.unwrapOptionField("policies", policies)
    def getLambdaConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaConfig", lambdaConfig)
    def getAutoVerifiedAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.VerifiedAttributeType
    ]] = AwsError.unwrapOptionField(
      "autoVerifiedAttributes",
      autoVerifiedAttributes
    )
    def getAliasAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AliasAttributeType
    ]] = AwsError.unwrapOptionField("aliasAttributes", aliasAttributes)
    def getUsernameAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.UsernameAttributeType
    ]] = AwsError.unwrapOptionField("usernameAttributes", usernameAttributes)
    def getSmsVerificationMessage
        : ZIO[Any, AwsError, SmsVerificationMessageType] = AwsError
      .unwrapOptionField("smsVerificationMessage", smsVerificationMessage)
    def getEmailVerificationMessage
        : ZIO[Any, AwsError, EmailVerificationMessageType] = AwsError
      .unwrapOptionField("emailVerificationMessage", emailVerificationMessage)
    def getEmailVerificationSubject
        : ZIO[Any, AwsError, EmailVerificationSubjectType] = AwsError
      .unwrapOptionField("emailVerificationSubject", emailVerificationSubject)
    def getVerificationMessageTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verificationMessageTemplate",
      verificationMessageTemplate
    )
    def getSmsAuthenticationMessage
        : ZIO[Any, AwsError, SmsVerificationMessageType] = AwsError
      .unwrapOptionField("smsAuthenticationMessage", smsAuthenticationMessage)
    def getMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = AwsError.unwrapOptionField("mfaConfiguration", mfaConfiguration)
    def getDeviceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("deviceConfiguration", deviceConfiguration)
    def getEmailConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("emailConfiguration", emailConfiguration)
    def getSmsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("smsConfiguration", smsConfiguration)
    def getUserPoolTags: ZIO[Any, AwsError, Map[TagKeysType, TagValueType]] =
      AwsError.unwrapOptionField("userPoolTags", userPoolTags)
    def getAdminCreateUserConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ] =
      AwsError.unwrapOptionField("adminCreateUserConfig", adminCreateUserConfig)
    def getSchema: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly
    ]] = AwsError.unwrapOptionField("schema", schema)
    def getUserPoolAddOns: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ] = AwsError.unwrapOptionField("userPoolAddOns", userPoolAddOns)
    def getUsernameConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType.ReadOnly
    ] =
      AwsError.unwrapOptionField("usernameConfiguration", usernameConfiguration)
    def getAccountRecoverySetting: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountRecoverySetting",
      accountRecoverySetting
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest
  ) extends zio.aws.cognitoidentityprovider.model.CreateUserPoolRequest.ReadOnly {
    override val poolName: UserPoolNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolNameType(impl.poolName())
    override val policies: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ] = scala
      .Option(impl.policies())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.wrap(value)
      )
    override val lambdaConfig: Option[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = scala
      .Option(impl.lambdaConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.LambdaConfigType.wrap(value)
      )
    override val autoVerifiedAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ] = scala
      .Option(impl.autoVerifiedAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.VerifiedAttributeType.wrap(item)
        }.toList
      )
    override val aliasAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AliasAttributeType]
    ] = scala
      .Option(impl.aliasAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AliasAttributeType.wrap(item)
        }.toList
      )
    override val usernameAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.UsernameAttributeType]
    ] = scala
      .Option(impl.usernameAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.UsernameAttributeType.wrap(item)
        }.toList
      )
    override val smsVerificationMessage: Option[SmsVerificationMessageType] =
      scala
        .Option(impl.smsVerificationMessage())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .SmsVerificationMessageType(value)
        )
    override val emailVerificationMessage
        : Option[EmailVerificationMessageType] = scala
      .Option(impl.emailVerificationMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationMessageType(value)
      )
    override val emailVerificationSubject
        : Option[EmailVerificationSubjectType] = scala
      .Option(impl.emailVerificationSubject())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationSubjectType(value)
      )
    override val verificationMessageTemplate: Option[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ] = scala
      .Option(impl.verificationMessageTemplate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType
          .wrap(value)
      )
    override val smsAuthenticationMessage: Option[SmsVerificationMessageType] =
      scala
        .Option(impl.smsAuthenticationMessage())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .SmsVerificationMessageType(value)
        )
    override val mfaConfiguration
        : Option[zio.aws.cognitoidentityprovider.model.UserPoolMfaType] = scala
      .Option(impl.mfaConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolMfaType.wrap(value)
      )
    override val deviceConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ] = scala
      .Option(impl.deviceConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.DeviceConfigurationType
          .wrap(value)
      )
    override val emailConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ] = scala
      .Option(impl.emailConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.EmailConfigurationType.wrap(value)
      )
    override val smsConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ] = scala
      .Option(impl.smsConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SmsConfigurationType.wrap(value)
      )
    override val userPoolTags: Option[Map[TagKeysType, TagValueType]] = scala
      .Option(impl.userPoolTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentityprovider.model.primitives.TagKeysType(
              key
            ) -> zio.aws.cognitoidentityprovider.model.primitives
              .TagValueType(value)
          })
          .toMap
      )
    override val adminCreateUserConfig: Option[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ] = scala
      .Option(impl.adminCreateUserConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType
          .wrap(value)
      )
    override val schema: Option[
      List[zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly]
    ] = scala
      .Option(impl.schema())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.SchemaAttributeType.wrap(item)
        }.toList
      )
    override val userPoolAddOns: Option[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ] = scala
      .Option(impl.userPoolAddOns())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.wrap(value)
      )
    override val usernameConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType.ReadOnly
    ] = scala
      .Option(impl.usernameConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UsernameConfigurationType
          .wrap(value)
      )
    override val accountRecoverySetting: Option[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ] = scala
      .Option(impl.accountRecoverySetting())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest
  ): zio.aws.cognitoidentityprovider.model.CreateUserPoolRequest.ReadOnly =
    new Wrapper(impl)
}
