package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait UsernameAttributeType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType
}
object UsernameAttributeType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType
  ): zio.aws.cognitoidentityprovider.model.UsernameAttributeType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType.PHONE_NUMBER =>
      val r = phone_number
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType.EMAIL =>
      val r = email
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.UsernameAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType.UNKNOWN_TO_SDK_VERSION
  }
  case object phone_number
      extends zio.aws.cognitoidentityprovider.model.UsernameAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType.PHONE_NUMBER
  }
  case object email
      extends zio.aws.cognitoidentityprovider.model.UsernameAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType.EMAIL
  }
}
