package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait EventType {
  def unwrap
      : software.amazon.awssdk.services.cognitoidentityprovider.model.EventType
}
object EventType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.EventType
  ): zio.aws.cognitoidentityprovider.model.EventType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventType.SIGN_IN =>
      val r = SignIn
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventType.SIGN_UP =>
      val r = SignUp
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventType.FORGOT_PASSWORD =>
      val r = ForgotPassword
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventType.UNKNOWN_TO_SDK_VERSION
  }
  case object SignIn extends zio.aws.cognitoidentityprovider.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventType.SIGN_IN
  }
  case object SignUp extends zio.aws.cognitoidentityprovider.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventType.SIGN_UP
  }
  case object ForgotPassword
      extends zio.aws.cognitoidentityprovider.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventType.FORGOT_PASSWORD
  }
}
