package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  PaginationKey,
  QueryLimitType,
  GroupNameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class ListUsersInGroupRequest(
    userPoolId: UserPoolIdType,
    groupName: GroupNameType,
    limit: Option[QueryLimitType] = None,
    nextToken: Option[PaginationKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest = {
    import ListUsersInGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .optionallyWith(
        limit.map(value => QueryLimitType.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest
      .wrap(buildAwsValue())
}
object ListUsersInGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest =
      zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest(
        userPoolId,
        groupName,
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def groupName: GroupNameType
    def limit: Option[QueryLimitType]
    def nextToken: Option[PaginationKey]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getLimit: ZIO[Any, AwsError, QueryLimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val groupName: GroupNameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .GroupNameType(impl.groupName())
    override val limit: Option[QueryLimitType] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.QueryLimitType(value)
      )
    override val nextToken: Option[PaginationKey] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest
  ): zio.aws.cognitoidentityprovider.model.ListUsersInGroupRequest.ReadOnly =
    new Wrapper(impl)
}
