package zio.aws.cognitoidentityprovider.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  PaginationKeyType,
  ListProvidersLimitType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class ListIdentityProvidersRequest(
    userPoolId: UserPoolIdType,
    maxResults: Option[ListProvidersLimitType] = None,
    nextToken: Option[PaginationKeyType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest = {
    import ListIdentityProvidersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => ListProvidersLimitType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          PaginationKeyType.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest
      .wrap(buildAwsValue())
}
object ListIdentityProvidersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest =
      zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest(
        userPoolId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def maxResults: Option[ListProvidersLimitType]
    def nextToken: Option[PaginationKeyType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getMaxResults: ZIO[Any, AwsError, ListProvidersLimitType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationKeyType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val maxResults: Option[ListProvidersLimitType] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .ListProvidersLimitType(value)
      )
    override val nextToken: Option[PaginationKeyType] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .PaginationKeyType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest
  ): zio.aws.cognitoidentityprovider.model.ListIdentityProvidersRequest.ReadOnly =
    new Wrapper(impl)
}
