package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  UserPoolIdType,
  UsernameType
}
import scala.jdk.CollectionConverters._
final case class AdminSetUserMfaPreferenceRequest(
    smsMfaSettings: Option[
      zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType
    ] = None,
    softwareTokenMfaSettings: Option[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType
    ] = None,
    username: UsernameType,
    userPoolId: UserPoolIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest = {
    import AdminSetUserMfaPreferenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest
      .builder()
      .optionallyWith(smsMfaSettings.map(value => value.buildAwsValue()))(
        _.smsMfaSettings
      )
      .optionallyWith(
        softwareTokenMfaSettings.map(value => value.buildAwsValue())
      )(_.softwareTokenMfaSettings)
      .username(UsernameType.unwrap(username): java.lang.String)
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest
      .wrap(buildAwsValue())
}
object AdminSetUserMfaPreferenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest =
      zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest(
        smsMfaSettings.map(value => value.asEditable),
        softwareTokenMfaSettings.map(value => value.asEditable),
        username,
        userPoolId
      )
    def smsMfaSettings: Option[
      zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType.ReadOnly
    ]
    def softwareTokenMfaSettings: Option[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType.ReadOnly
    ]
    def username: UsernameType
    def userPoolId: UserPoolIdType
    def getSmsMfaSettings: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType.ReadOnly
    ] = AwsError.unwrapOptionField("smsMfaSettings", smsMfaSettings)
    def getSoftwareTokenMfaSettings: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "softwareTokenMfaSettings",
      softwareTokenMfaSettings
    )
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest.ReadOnly {
    override val smsMfaSettings: Option[
      zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType.ReadOnly
    ] = scala
      .Option(impl.smsMfaSettings())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SMSMfaSettingsType.wrap(value)
      )
    override val softwareTokenMfaSettings: Option[
      zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType.ReadOnly
    ] = scala
      .Option(impl.softwareTokenMfaSettings())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType
          .wrap(value)
      )
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest
  ): zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest.ReadOnly =
    new Wrapper(impl)
}
