package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminDisableUserRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest = {
    import AdminDisableUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminDisableUserRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminDisableUserRequest
      .wrap(buildAwsValue())
}
object AdminDisableUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminDisableUserRequest =
      zio.aws.cognitoidentityprovider.model
        .AdminDisableUserRequest(userPoolId, username)
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminDisableUserRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest
  ): zio.aws.cognitoidentityprovider.model.AdminDisableUserRequest.ReadOnly =
    new Wrapper(impl)
}
