package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cognitoidentityprovider.model.primitives.{
  StringType,
  UsernameType
}
import scala.jdk.CollectionConverters._
final case class GetUserResponse(
    username: UsernameType,
    userAttributes: Iterable[
      zio.aws.cognitoidentityprovider.model.AttributeType
    ],
    mfaOptions: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.MFAOptionType]
    ] = None,
    preferredMfaSetting: Option[StringType] = None,
    userMFASettingList: Option[Iterable[StringType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse = {
    import GetUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse
      .builder()
      .username(UsernameType.unwrap(username): java.lang.String)
      .userAttributes(userAttributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        mfaOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mfaOptions)
      .optionallyWith(
        preferredMfaSetting.map(value =>
          StringType.unwrap(value): java.lang.String
        )
      )(_.preferredMfaSetting)
      .optionallyWith(
        userMFASettingList.map(value =>
          value.map { item =>
            StringType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userMFASettingList)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetUserResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetUserResponse.wrap(buildAwsValue())
}
object GetUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GetUserResponse =
      zio.aws.cognitoidentityprovider.model.GetUserResponse(
        username,
        userAttributes.map { item =>
          item.asEditable
        },
        mfaOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        preferredMfaSetting.map(value => value),
        userMFASettingList.map(value => value)
      )
    def username: UsernameType
    def userAttributes
        : List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    def mfaOptions: Option[
      List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    ]
    def preferredMfaSetting: Option[StringType]
    def userMFASettingList: Option[List[StringType]]
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getUserAttributes: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = ZIO.succeed(userAttributes)
    def getMfaOptions: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly
    ]] = AwsError.unwrapOptionField("mfaOptions", mfaOptions)
    def getPreferredMfaSetting: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("preferredMfaSetting", preferredMfaSetting)
    def getUserMFASettingList: ZIO[Any, AwsError, List[StringType]] =
      AwsError.unwrapOptionField("userMFASettingList", userMFASettingList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse
  ) extends zio.aws.cognitoidentityprovider.model.GetUserResponse.ReadOnly {
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val userAttributes
        : List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly] =
      impl
        .userAttributes()
        .asScala
        .map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }
        .toList
    override val mfaOptions: Option[
      List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    ] = scala
      .Option(impl.mfaOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.MFAOptionType.wrap(item)
        }.toList
      )
    override val preferredMfaSetting: Option[StringType] = scala
      .Option(impl.preferredMfaSetting())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.StringType(value)
      )
    override val userMFASettingList: Option[List[StringType]] = scala
      .Option(impl.userMFASettingList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.primitives.StringType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse
  ): zio.aws.cognitoidentityprovider.model.GetUserResponse.ReadOnly =
    new Wrapper(impl)
}
