package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.cognitoidentityprovider.model.primitives.{
  DateType,
  DeviceKeyType
}
import scala.jdk.CollectionConverters._
final case class DeviceType(
    deviceKey: Option[DeviceKeyType] = None,
    deviceAttributes: Option[
      Iterable[zio.aws.cognitoidentityprovider.model.AttributeType]
    ] = None,
    deviceCreateDate: Option[DateType] = None,
    deviceLastModifiedDate: Option[DateType] = None,
    deviceLastAuthenticatedDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceType = {
    import DeviceType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceType
      .builder()
      .optionallyWith(
        deviceKey.map(value => DeviceKeyType.unwrap(value): java.lang.String)
      )(_.deviceKey)
      .optionallyWith(
        deviceAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceAttributes)
      .optionallyWith(
        deviceCreateDate.map(value => DateType.unwrap(value): Instant)
      )(_.deviceCreateDate)
      .optionallyWith(
        deviceLastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.deviceLastModifiedDate)
      .optionallyWith(
        deviceLastAuthenticatedDate.map(value =>
          DateType.unwrap(value): Instant
        )
      )(_.deviceLastAuthenticatedDate)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DeviceType.wrap(buildAwsValue())
}
object DeviceType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.DeviceType =
      zio.aws.cognitoidentityprovider.model.DeviceType(
        deviceKey.map(value => value),
        deviceAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deviceCreateDate.map(value => value),
        deviceLastModifiedDate.map(value => value),
        deviceLastAuthenticatedDate.map(value => value)
      )
    def deviceKey: Option[DeviceKeyType]
    def deviceAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ]
    def deviceCreateDate: Option[DateType]
    def deviceLastModifiedDate: Option[DateType]
    def deviceLastAuthenticatedDate: Option[DateType]
    def getDeviceKey: ZIO[Any, AwsError, DeviceKeyType] =
      AwsError.unwrapOptionField("deviceKey", deviceKey)
    def getDeviceAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceAttributes", deviceAttributes)
    def getDeviceCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("deviceCreateDate", deviceCreateDate)
    def getDeviceLastModifiedDate: ZIO[Any, AwsError, DateType] = AwsError
      .unwrapOptionField("deviceLastModifiedDate", deviceLastModifiedDate)
    def getDeviceLastAuthenticatedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField(
        "deviceLastAuthenticatedDate",
        deviceLastAuthenticatedDate
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceType
  ) extends zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly {
    override val deviceKey: Option[DeviceKeyType] = scala
      .Option(impl.deviceKey())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DeviceKeyType(value)
      )
    override val deviceAttributes: Option[
      List[zio.aws.cognitoidentityprovider.model.AttributeType.ReadOnly]
    ] = scala
      .Option(impl.deviceAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AttributeType.wrap(item)
        }.toList
      )
    override val deviceCreateDate: Option[DateType] = scala
      .Option(impl.deviceCreateDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val deviceLastModifiedDate: Option[DateType] = scala
      .Option(impl.deviceLastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val deviceLastAuthenticatedDate: Option[DateType] = scala
      .Option(impl.deviceLastAuthenticatedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceType
  ): zio.aws.cognitoidentityprovider.model.DeviceType.ReadOnly = new Wrapper(
    impl
  )
}
