package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait VerifiedAttributeType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType
}
object VerifiedAttributeType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType
  ): zio.aws.cognitoidentityprovider.model.VerifiedAttributeType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType.PHONE_NUMBER =>
      val r = phone_number
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType.EMAIL =>
      val r = email
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.VerifiedAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType.UNKNOWN_TO_SDK_VERSION
  }
  case object phone_number
      extends zio.aws.cognitoidentityprovider.model.VerifiedAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType.PHONE_NUMBER
  }
  case object email
      extends zio.aws.cognitoidentityprovider.model.VerifiedAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType.EMAIL
  }
}
