package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UserPoolPolicyType(
    passwordPolicy: Option[
      zio.aws.cognitoidentityprovider.model.PasswordPolicyType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolPolicyType = {
    import UserPoolPolicyType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolPolicyType
      .builder()
      .optionallyWith(passwordPolicy.map(value => value.buildAwsValue()))(
        _.passwordPolicy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserPoolPolicyType
      .wrap(buildAwsValue())
}
object UserPoolPolicyType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolPolicyType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UserPoolPolicyType =
      zio.aws.cognitoidentityprovider.model
        .UserPoolPolicyType(passwordPolicy.map(value => value.asEditable))
    def passwordPolicy: Option[
      zio.aws.cognitoidentityprovider.model.PasswordPolicyType.ReadOnly
    ]
    def getPasswordPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.PasswordPolicyType.ReadOnly
    ] = AwsError.unwrapOptionField("passwordPolicy", passwordPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolPolicyType
  ) extends zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly {
    override val passwordPolicy: Option[
      zio.aws.cognitoidentityprovider.model.PasswordPolicyType.ReadOnly
    ] = scala
      .Option(impl.passwordPolicy())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.PasswordPolicyType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolPolicyType
  ): zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly =
    new Wrapper(impl)
}
