package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait StatusType {
  def unwrap
      : software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType
}
object StatusType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType
  ): zio.aws.cognitoidentityprovider.model.StatusType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.cognitoidentityprovider.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType.ENABLED
  }
  case object Disabled
      extends zio.aws.cognitoidentityprovider.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType.DISABLED
  }
}
