package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType
import scala.jdk.CollectionConverters._
final case class DeleteUserPoolRequest(userPoolId: UserPoolIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest = {
    import DeleteUserPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DeleteUserPoolRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DeleteUserPoolRequest
      .wrap(buildAwsValue())
}
object DeleteUserPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DeleteUserPoolRequest =
      zio.aws.cognitoidentityprovider.model.DeleteUserPoolRequest(userPoolId)
    def userPoolId: UserPoolIdType
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest
  ) extends zio.aws.cognitoidentityprovider.model.DeleteUserPoolRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest
  ): zio.aws.cognitoidentityprovider.model.DeleteUserPoolRequest.ReadOnly =
    new Wrapper(impl)
}
