package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.cognitoidentityprovider.model.primitives.{
  IdpIdentifierType,
  DateType,
  UserPoolIdType,
  AttributeMappingKeyType,
  ProviderNameType,
  StringType
}
import scala.jdk.CollectionConverters._
final case class IdentityProviderType(
    userPoolId: Option[UserPoolIdType] = None,
    providerName: Option[ProviderNameType] = None,
    providerType: Option[
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ] = None,
    providerDetails: Option[Map[StringType, StringType]] = None,
    attributeMapping: Option[Map[AttributeMappingKeyType, StringType]] = None,
    idpIdentifiers: Option[Iterable[IdpIdentifierType]] = None,
    lastModifiedDate: Option[DateType] = None,
    creationDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType = {
    import IdentityProviderType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType
      .builder()
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        providerName.map(value =>
          ProviderNameType.unwrap(value): java.lang.String
        )
      )(_.providerName)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(
        providerDetails.map(value =>
          value
            .map({ case (key, value) =>
              (StringType.unwrap(key): java.lang.String) -> (StringType.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.providerDetails)
      .optionallyWith(
        attributeMapping.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeMappingKeyType.unwrap(
                key
              ): java.lang.String) -> (StringType.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.attributeMapping)
      .optionallyWith(
        idpIdentifiers.map(value =>
          value.map { item =>
            IdpIdentifierType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.idpIdentifiers)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.IdentityProviderType
      .wrap(buildAwsValue())
}
object IdentityProviderType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.IdentityProviderType =
      zio.aws.cognitoidentityprovider.model.IdentityProviderType(
        userPoolId.map(value => value),
        providerName.map(value => value),
        providerType.map(value => value),
        providerDetails.map(value => value),
        attributeMapping.map(value => value),
        idpIdentifiers.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value)
      )
    def userPoolId: Option[UserPoolIdType]
    def providerName: Option[ProviderNameType]
    def providerType
        : Option[zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType]
    def providerDetails: Option[Map[StringType, StringType]]
    def attributeMapping: Option[Map[AttributeMappingKeyType, StringType]]
    def idpIdentifiers: Option[List[IdpIdentifierType]]
    def lastModifiedDate: Option[DateType]
    def creationDate: Option[DateType]
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getProviderName: ZIO[Any, AwsError, ProviderNameType] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getProviderType: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ] = AwsError.unwrapOptionField("providerType", providerType)
    def getProviderDetails: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("providerDetails", providerDetails)
    def getAttributeMapping
        : ZIO[Any, AwsError, Map[AttributeMappingKeyType, StringType]] =
      AwsError.unwrapOptionField("attributeMapping", attributeMapping)
    def getIdpIdentifiers: ZIO[Any, AwsError, List[IdpIdentifierType]] =
      AwsError.unwrapOptionField("idpIdentifiers", idpIdentifiers)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType
  ) extends zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly {
    override val userPoolId: Option[UserPoolIdType] = scala
      .Option(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val providerName: Option[ProviderNameType] = scala
      .Option(impl.providerName())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ProviderNameType(value)
      )
    override val providerType: Option[
      zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
    ] = scala
      .Option(impl.providerType())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.IdentityProviderTypeType
          .wrap(value)
      )
    override val providerDetails: Option[Map[StringType, StringType]] = scala
      .Option(impl.providerDetails())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentityprovider.model.primitives.StringType(
              key
            ) -> zio.aws.cognitoidentityprovider.model.primitives
              .StringType(value)
          })
          .toMap
      )
    override val attributeMapping
        : Option[Map[AttributeMappingKeyType, StringType]] = scala
      .Option(impl.attributeMapping())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cognitoidentityprovider.model.primitives
              .AttributeMappingKeyType(
                key
              ) -> zio.aws.cognitoidentityprovider.model.primitives
              .StringType(value)
          })
          .toMap
      )
    override val idpIdentifiers: Option[List[IdpIdentifierType]] = scala
      .Option(impl.idpIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.primitives
            .IdpIdentifierType(item)
        }.toList
      )
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType
  ): zio.aws.cognitoidentityprovider.model.IdentityProviderType.ReadOnly =
    new Wrapper(impl)
}
