package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ForgotPasswordResponse(
    codeDeliveryDetails: Option[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse = {
    import ForgotPasswordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse
      .builder()
      .optionallyWith(codeDeliveryDetails.map(value => value.buildAwsValue()))(
        _.codeDeliveryDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse
      .wrap(buildAwsValue())
}
object ForgotPasswordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse =
      zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse(
        codeDeliveryDetails.map(value => value.asEditable)
      )
    def codeDeliveryDetails: Option[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ]
    def getCodeDeliveryDetails: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ] = AwsError.unwrapOptionField("codeDeliveryDetails", codeDeliveryDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse
  ) extends zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse.ReadOnly {
    override val codeDeliveryDetails: Option[
      zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType.ReadOnly
    ] = scala
      .Option(impl.codeDeliveryDetails())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CodeDeliveryDetailsType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse
  ): zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse.ReadOnly =
    new Wrapper(impl)
}
