package zio.aws.cognitoidentityprovider
import zio.aws.cognitoidentityprovider.model.AdminDisableProviderForUserResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.cognitoidentityprovider.model.{
  CreateResourceServerRequest,
  GetCsvHeaderRequest,
  DeleteUserRequest,
  SignUpRequest,
  AssociateSoftwareTokenRequest,
  CreateUserPoolDomainRequest,
  ForgetDeviceRequest,
  DeleteUserPoolRequest,
  SetUserMfaPreferenceRequest,
  ChangePasswordRequest,
  AdminDeleteUserAttributesRequest,
  AdminSetUserMfaPreferenceRequest,
  InitiateAuthRequest,
  AdminSetUserPasswordRequest,
  UpdateUserPoolRequest,
  AddCustomAttributesRequest,
  RespondToAuthChallengeRequest,
  GetUserAttributeVerificationCodeRequest,
  ListResourceServersRequest,
  UpdateUserAttributesRequest,
  ResendConfirmationCodeRequest,
  ConfirmSignUpRequest,
  ConfirmDeviceRequest,
  AdminDisableProviderForUserRequest,
  GetIdentityProviderByIdentifierRequest,
  GetGroupRequest,
  DescribeIdentityProviderRequest,
  ListUsersRequest,
  ListUserPoolClientsRequest,
  GetUserPoolMfaConfigRequest,
  AdminUserGlobalSignOutRequest,
  AdminForgetDeviceRequest,
  UpdateGroupRequest,
  StopUserImportJobRequest,
  ListUserImportJobsRequest,
  SetUserSettingsRequest,
  AdminUpdateAuthEventFeedbackRequest,
  ListIdentityProvidersRequest,
  CreateIdentityProviderRequest,
  SetUiCustomizationRequest,
  CreateUserPoolRequest,
  AdminLinkProviderForUserRequest,
  GetDeviceRequest,
  ConfirmForgotPasswordRequest,
  AdminInitiateAuthRequest,
  DescribeUserPoolRequest,
  ListTagsForResourceRequest,
  SetUserPoolMfaConfigRequest,
  AdminListGroupsForUserRequest,
  DescribeUserPoolClientRequest,
  AdminDisableUserRequest,
  DeleteGroupRequest,
  AdminGetDeviceRequest,
  AdminConfirmSignUpRequest,
  CreateUserImportJobRequest,
  ListGroupsRequest,
  GetUiCustomizationRequest,
  UpdateDeviceStatusRequest,
  GlobalSignOutRequest,
  StartUserImportJobRequest,
  UpdateUserPoolDomainRequest,
  AdminEnableUserRequest,
  VerifyUserAttributeRequest,
  AdminGetUserRequest,
  AdminListDevicesRequest,
  DescribeUserImportJobRequest,
  UpdateIdentityProviderRequest,
  DeleteUserPoolClientRequest,
  GetUserRequest,
  DeleteResourceServerRequest,
  AdminListUserAuthEventsRequest,
  DeleteUserPoolDomainRequest,
  ListUserPoolsRequest,
  CreateUserPoolClientRequest,
  UntagResourceRequest,
  AdminAddUserToGroupRequest,
  SetRiskConfigurationRequest,
  ListUsersInGroupRequest,
  DescribeUserPoolDomainRequest,
  ForgotPasswordRequest,
  AdminRespondToAuthChallengeRequest,
  CreateGroupRequest,
  AdminResetUserPasswordRequest,
  AdminRemoveUserFromGroupRequest,
  ListDevicesRequest,
  RevokeTokenRequest,
  VerifySoftwareTokenRequest,
  AdminUpdateDeviceStatusRequest,
  AdminCreateUserRequest,
  DescribeRiskConfigurationRequest,
  GetSigningCertificateRequest,
  DeleteUserAttributesRequest,
  UpdateUserPoolClientRequest,
  UpdateResourceServerRequest,
  AdminDeleteUserRequest,
  TagResourceRequest,
  DescribeResourceServerRequest,
  AdminUpdateUserAttributesRequest,
  DeleteIdentityProviderRequest,
  AdminSetUserSettingsRequest,
  UpdateAuthEventFeedbackRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClient
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object CognitoIdentityProviderMock extends Mock[CognitoIdentityProvider] {
  object AdminConfirmSignUp
      extends Effect[
        AdminConfirmSignUpRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpResponse.ReadOnly
      ]
  object CreateIdentityProvider
      extends Effect[
        CreateIdentityProviderRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.CreateIdentityProviderResponse.ReadOnly
      ]
  object AdminEnableUser
      extends Effect[
        AdminEnableUserRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminEnableUserResponse.ReadOnly
      ]
  object RevokeToken
      extends Effect[
        RevokeTokenRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.RevokeTokenResponse.ReadOnly
      ]
  object StopUserImportJob
      extends Effect[
        StopUserImportJobRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.StopUserImportJobResponse.ReadOnly
      ]
  object AdminRemoveUserFromGroup
      extends Effect[AdminRemoveUserFromGroupRequest, AwsError, Unit]
  object DescribeUserPoolDomain
      extends Effect[
        DescribeUserPoolDomainRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse.ReadOnly
      ]
  object ListUsers
      extends Stream[
        ListUsersRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
      ]
  object ListUsersPaginated
      extends Effect[
        ListUsersRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ListUsersResponse.ReadOnly
      ]
  object ListUsersInGroup
      extends Stream[
        ListUsersInGroupRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
      ]
  object ListUsersInGroupPaginated
      extends Effect[
        ListUsersInGroupRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse.ReadOnly
      ]
  object GlobalSignOut
      extends Effect[
        GlobalSignOutRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GlobalSignOutResponse.ReadOnly
      ]
  object AdminGetUser
      extends Effect[
        AdminGetUserRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.ReadOnly
      ]
  object CreateUserPoolDomain
      extends Effect[
        CreateUserPoolDomainRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainResponse.ReadOnly
      ]
  object AssociateSoftwareToken
      extends Effect[
        AssociateSoftwareTokenRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.ReadOnly
      ]
  object AdminUpdateAuthEventFeedback
      extends Effect[
        AdminUpdateAuthEventFeedbackRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse.ReadOnly
      ]
  object DescribeUserPool
      extends Effect[
        DescribeUserPoolRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.DescribeUserPoolResponse.ReadOnly
      ]
  object DescribeIdentityProvider
      extends Effect[
        DescribeIdentityProviderRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.DescribeIdentityProviderResponse.ReadOnly
      ]
  object AdminUpdateDeviceStatus
      extends Effect[
        AdminUpdateDeviceStatusRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse.ReadOnly
      ]
  object AdminUpdateUserAttributes
      extends Effect[
        AdminUpdateUserAttributesRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse.ReadOnly
      ]
  object ResendConfirmationCode
      extends Effect[
        ResendConfirmationCodeRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse.ReadOnly
      ]
  object SignUp
      extends Effect[
        SignUpRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.SignUpResponse.ReadOnly
      ]
  object DeleteIdentityProvider
      extends Effect[DeleteIdentityProviderRequest, AwsError, Unit]
  object GetUserAttributeVerificationCode
      extends Effect[
        GetUserAttributeVerificationCodeRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse.ReadOnly
      ]
  object DeleteUserPoolClient
      extends Effect[DeleteUserPoolClientRequest, AwsError, Unit]
  object DeleteGroup extends Effect[DeleteGroupRequest, AwsError, Unit]
  object AdminSetUserSettings
      extends Effect[
        AdminSetUserSettingsRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsResponse.ReadOnly
      ]
  object GetSigningCertificate
      extends Effect[
        GetSigningCertificateRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.ReadOnly
      ]
  object GetUserPoolMfaConfig
      extends Effect[
        GetUserPoolMfaConfigRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse.ReadOnly
      ]
  object UpdateUserPoolClient
      extends Effect[
        UpdateUserPoolClientRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse.ReadOnly
      ]
  object InitiateAuth
      extends Effect[
        InitiateAuthRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.InitiateAuthResponse.ReadOnly
      ]
  object ChangePassword
      extends Effect[
        ChangePasswordRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ChangePasswordResponse.ReadOnly
      ]
  object AdminListGroupsForUser
      extends Stream[
        AdminListGroupsForUserRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
      ]
  object AdminListGroupsForUserPaginated
      extends Effect[
        AdminListGroupsForUserRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse.ReadOnly
      ]
  object DeleteUserAttributes
      extends Effect[
        DeleteUserAttributesRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.DeleteUserAttributesResponse.ReadOnly
      ]
  object AdminResetUserPassword
      extends Effect[
        AdminResetUserPasswordRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminResetUserPasswordResponse.ReadOnly
      ]
  object AddCustomAttributes
      extends Effect[
        AddCustomAttributesRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AddCustomAttributesResponse.ReadOnly
      ]
  object AdminUserGlobalSignOut
      extends Effect[
        AdminUserGlobalSignOutRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse.ReadOnly
      ]
  object GetUICustomization
      extends Effect[
        GetUiCustomizationRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GetUiCustomizationResponse.ReadOnly
      ]
  object CreateResourceServer
      extends Effect[
        CreateResourceServerRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.CreateResourceServerResponse.ReadOnly
      ]
  object AdminDisableUser
      extends Effect[
        AdminDisableUserRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminDisableUserResponse.ReadOnly
      ]
  object RespondToAuthChallenge
      extends Effect[
        RespondToAuthChallengeRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse.ReadOnly
      ]
  object GetUser
      extends Effect[
        GetUserRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GetUserResponse.ReadOnly
      ]
  object DeleteResourceServer
      extends Effect[DeleteResourceServerRequest, AwsError, Unit]
  object ListGroups
      extends Stream[
        ListGroupsRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
      ]
  object ListGroupsPaginated
      extends Effect[
        ListGroupsRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ListGroupsResponse.ReadOnly
      ]
  object ListDevices
      extends Effect[
        ListDevicesRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ListDevicesResponse.ReadOnly
      ]
  object VerifySoftwareToken
      extends Effect[
        VerifySoftwareTokenRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse.ReadOnly
      ]
  object AdminDisableProviderForUser
      extends Effect[AdminDisableProviderForUserRequest, AwsError, ReadOnly]
  object ForgotPassword
      extends Effect[
        ForgotPasswordRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse.ReadOnly
      ]
  object UpdateAuthEventFeedback
      extends Effect[
        UpdateAuthEventFeedbackRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse.ReadOnly
      ]
  object UpdateIdentityProvider
      extends Effect[
        UpdateIdentityProviderRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderResponse.ReadOnly
      ]
  object ListUserPoolClients
      extends Stream[
        ListUserPoolClientsRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UserPoolClientDescription.ReadOnly
      ]
  object ListUserPoolClientsPaginated
      extends Effect[
        ListUserPoolClientsRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse.ReadOnly
      ]
  object StartUserImportJob
      extends Effect[
        StartUserImportJobRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse.ReadOnly
      ]
  object UpdateUserAttributes
      extends Effect[
        UpdateUserAttributesRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse.ReadOnly
      ]
  object AdminListUserAuthEvents
      extends Stream[
        AdminListUserAuthEventsRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly
      ]
  object AdminListUserAuthEventsPaginated
      extends Effect[
        AdminListUserAuthEventsRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.ReadOnly
      ]
  object ListIdentityProviders
      extends Stream[
        ListIdentityProvidersRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ProviderDescription.ReadOnly
      ]
  object ListIdentityProvidersPaginated
      extends Effect[
        ListIdentityProvidersRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse.ReadOnly
      ]
  object ListUserImportJobs
      extends Effect[
        ListUserImportJobsRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse.ReadOnly
      ]
  object AdminCreateUser
      extends Effect[
        AdminCreateUserRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminCreateUserResponse.ReadOnly
      ]
  object AdminInitiateAuth
      extends Effect[
        AdminInitiateAuthRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse.ReadOnly
      ]
  object ConfirmSignUp
      extends Effect[
        ConfirmSignUpRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ConfirmSignUpResponse.ReadOnly
      ]
  object AdminGetDevice
      extends Effect[
        AdminGetDeviceRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminGetDeviceResponse.ReadOnly
      ]
  object AdminLinkProviderForUser
      extends Effect[
        AdminLinkProviderForUserRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserResponse.ReadOnly
      ]
  object ConfirmForgotPassword
      extends Effect[
        ConfirmForgotPasswordRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordResponse.ReadOnly
      ]
  object SetRiskConfiguration
      extends Effect[
        SetRiskConfigurationRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.SetRiskConfigurationResponse.ReadOnly
      ]
  object ForgetDevice extends Effect[ForgetDeviceRequest, AwsError, Unit]
  object DeleteUserPool extends Effect[DeleteUserPoolRequest, AwsError, Unit]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UntagResourceResponse.ReadOnly
      ]
  object ListResourceServers
      extends Stream[
        ListResourceServersRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly
      ]
  object ListResourceServersPaginated
      extends Effect[
        ListResourceServersRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ListResourceServersResponse.ReadOnly
      ]
  object DescribeUserImportJob
      extends Effect[
        DescribeUserImportJobRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse.ReadOnly
      ]
  object DeleteUserPoolDomain
      extends Effect[
        DeleteUserPoolDomainRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.DeleteUserPoolDomainResponse.ReadOnly
      ]
  object SetUserSettings
      extends Effect[
        SetUserSettingsRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.SetUserSettingsResponse.ReadOnly
      ]
  object AdminDeleteUser extends Effect[AdminDeleteUserRequest, AwsError, Unit]
  object AdminRespondToAuthChallenge
      extends Effect[
        AdminRespondToAuthChallengeRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse.ReadOnly
      ]
  object CreateGroup
      extends Effect[
        CreateGroupRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.CreateGroupResponse.ReadOnly
      ]
  object AdminAddUserToGroup
      extends Effect[AdminAddUserToGroupRequest, AwsError, Unit]
  object AdminSetUserPassword
      extends Effect[
        AdminSetUserPasswordRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordResponse.ReadOnly
      ]
  object SetUserMFAPreference
      extends Effect[
        SetUserMfaPreferenceRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceResponse.ReadOnly
      ]
  object UpdateUserPoolDomain
      extends Effect[
        UpdateUserPoolDomainRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainResponse.ReadOnly
      ]
  object SetUICustomization
      extends Effect[
        SetUiCustomizationRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.SetUiCustomizationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ListTagsForResourceResponse.ReadOnly
      ]
  object UpdateGroup
      extends Effect[
        UpdateGroupRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UpdateGroupResponse.ReadOnly
      ]
  object ConfirmDevice
      extends Effect[
        ConfirmDeviceRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.TagResourceResponse.ReadOnly
      ]
  object AdminDeleteUserAttributes
      extends Effect[
        AdminDeleteUserAttributesRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse.ReadOnly
      ]
  object AdminForgetDevice
      extends Effect[AdminForgetDeviceRequest, AwsError, Unit]
  object CreateUserPool
      extends Effect[
        CreateUserPoolRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.CreateUserPoolResponse.ReadOnly
      ]
  object DeleteUser extends Effect[DeleteUserRequest, AwsError, Unit]
  object CreateUserImportJob
      extends Effect[
        CreateUserImportJobRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse.ReadOnly
      ]
  object GetGroup
      extends Effect[
        GetGroupRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GetGroupResponse.ReadOnly
      ]
  object CreateUserPoolClient
      extends Effect[
        CreateUserPoolClientRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse.ReadOnly
      ]
  object UpdateUserPool
      extends Effect[
        UpdateUserPoolRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UpdateUserPoolResponse.ReadOnly
      ]
  object UpdateDeviceStatus
      extends Effect[
        UpdateDeviceStatusRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusResponse.ReadOnly
      ]
  object DescribeUserPoolClient
      extends Effect[
        DescribeUserPoolClientRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse.ReadOnly
      ]
  object GetCSVHeader
      extends Effect[
        GetCsvHeaderRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse.ReadOnly
      ]
  object DescribeResourceServer
      extends Effect[
        DescribeResourceServerRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.DescribeResourceServerResponse.ReadOnly
      ]
  object SetUserPoolMfaConfig
      extends Effect[
        SetUserPoolMfaConfigRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.ReadOnly
      ]
  object DescribeRiskConfiguration
      extends Effect[
        DescribeRiskConfigurationRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationResponse.ReadOnly
      ]
  object ListUserPools
      extends Stream[
        ListUserPoolsRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly
      ]
  object ListUserPoolsPaginated
      extends Effect[
        ListUserPoolsRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.ReadOnly
      ]
  object AdminListDevices
      extends Effect[
        AdminListDevicesRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse.ReadOnly
      ]
  object GetDevice
      extends Effect[
        GetDeviceRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GetDeviceResponse.ReadOnly
      ]
  object AdminSetUserMFAPreference
      extends Effect[
        AdminSetUserMfaPreferenceRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse.ReadOnly
      ]
  object UpdateResourceServer
      extends Effect[
        UpdateResourceServerRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.UpdateResourceServerResponse.ReadOnly
      ]
  object VerifyUserAttribute
      extends Effect[
        VerifyUserAttributeRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.VerifyUserAttributeResponse.ReadOnly
      ]
  object GetIdentityProviderByIdentifier
      extends Effect[
        GetIdentityProviderByIdentifierRequest,
        AwsError,
        zio.aws.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CognitoIdentityProvider] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new CognitoIdentityProvider {
          val api: CognitoIdentityProviderAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : CognitoIdentityProvider = this
          def adminConfirmSignUp(request: AdminConfirmSignUpRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminConfirmSignUpResponse.ReadOnly
          ] = proxy(AdminConfirmSignUp, request)
          def createIdentityProvider(
              request: CreateIdentityProviderRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.CreateIdentityProviderResponse.ReadOnly
          ] = proxy(CreateIdentityProvider, request)
          def adminEnableUser(request: AdminEnableUserRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminEnableUserResponse.ReadOnly
          ] = proxy(AdminEnableUser, request)
          def revokeToken(request: RevokeTokenRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.RevokeTokenResponse.ReadOnly
          ] = proxy(RevokeToken, request)
          def stopUserImportJob(request: StopUserImportJobRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.StopUserImportJobResponse.ReadOnly
          ] = proxy(StopUserImportJob, request)
          def adminRemoveUserFromGroup(
              request: AdminRemoveUserFromGroupRequest
          ): IO[AwsError, Unit] = proxy(AdminRemoveUserFromGroup, request)
          def describeUserPoolDomain(
              request: DescribeUserPoolDomainRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.DescribeUserPoolDomainResponse.ReadOnly
          ] = proxy(DescribeUserPoolDomain, request)
          def listUsers(request: ListUsersRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
          ] = rts.unsafeRun(proxy(ListUsers, request))
          def listUsersPaginated(request: ListUsersRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ListUsersResponse.ReadOnly
          ] = proxy(ListUsersPaginated, request)
          def listUsersInGroup(request: ListUsersInGroupRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cognitoidentityprovider.model.UserType.ReadOnly
          ] = rts.unsafeRun(proxy(ListUsersInGroup, request))
          def listUsersInGroupPaginated(request: ListUsersInGroupRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ListUsersInGroupResponse.ReadOnly
          ] = proxy(ListUsersInGroupPaginated, request)
          def globalSignOut(request: GlobalSignOutRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.GlobalSignOutResponse.ReadOnly
          ] = proxy(GlobalSignOut, request)
          def adminGetUser(request: AdminGetUserRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminGetUserResponse.ReadOnly
          ] = proxy(AdminGetUser, request)
          def createUserPoolDomain(request: CreateUserPoolDomainRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.CreateUserPoolDomainResponse.ReadOnly
          ] = proxy(CreateUserPoolDomain, request)
          def associateSoftwareToken(
              request: AssociateSoftwareTokenRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AssociateSoftwareTokenResponse.ReadOnly
          ] = proxy(AssociateSoftwareToken, request)
          def adminUpdateAuthEventFeedback(
              request: AdminUpdateAuthEventFeedbackRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse.ReadOnly
          ] = proxy(AdminUpdateAuthEventFeedback, request)
          def describeUserPool(request: DescribeUserPoolRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.DescribeUserPoolResponse.ReadOnly
          ] = proxy(DescribeUserPool, request)
          def describeIdentityProvider(
              request: DescribeIdentityProviderRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.DescribeIdentityProviderResponse.ReadOnly
          ] = proxy(DescribeIdentityProvider, request)
          def adminUpdateDeviceStatus(
              request: AdminUpdateDeviceStatusRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse.ReadOnly
          ] = proxy(AdminUpdateDeviceStatus, request)
          def adminUpdateUserAttributes(
              request: AdminUpdateUserAttributesRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse.ReadOnly
          ] = proxy(AdminUpdateUserAttributes, request)
          def resendConfirmationCode(
              request: ResendConfirmationCodeRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ResendConfirmationCodeResponse.ReadOnly
          ] = proxy(ResendConfirmationCode, request)
          def signUp(request: SignUpRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.SignUpResponse.ReadOnly
          ] = proxy(SignUp, request)
          def deleteIdentityProvider(
              request: DeleteIdentityProviderRequest
          ): IO[AwsError, Unit] = proxy(DeleteIdentityProvider, request)
          def getUserAttributeVerificationCode(
              request: GetUserAttributeVerificationCodeRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse.ReadOnly
          ] = proxy(GetUserAttributeVerificationCode, request)
          def deleteUserPoolClient(
              request: DeleteUserPoolClientRequest
          ): IO[AwsError, Unit] = proxy(DeleteUserPoolClient, request)
          def deleteGroup(request: DeleteGroupRequest): IO[AwsError, Unit] =
            proxy(DeleteGroup, request)
          def adminSetUserSettings(request: AdminSetUserSettingsRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsResponse.ReadOnly
          ] = proxy(AdminSetUserSettings, request)
          def getSigningCertificate(request: GetSigningCertificateRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.ReadOnly
          ] = proxy(GetSigningCertificate, request)
          def getUserPoolMfaConfig(request: GetUserPoolMfaConfigRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse.ReadOnly
          ] = proxy(GetUserPoolMfaConfig, request)
          def updateUserPoolClient(request: UpdateUserPoolClientRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.UpdateUserPoolClientResponse.ReadOnly
          ] = proxy(UpdateUserPoolClient, request)
          def initiateAuth(request: InitiateAuthRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.InitiateAuthResponse.ReadOnly
          ] = proxy(InitiateAuth, request)
          def changePassword(request: ChangePasswordRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ChangePasswordResponse.ReadOnly
          ] = proxy(ChangePassword, request)
          def adminListGroupsForUser(
              request: AdminListGroupsForUserRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
          ] = rts.unsafeRun(proxy(AdminListGroupsForUser, request))
          def adminListGroupsForUserPaginated(
              request: AdminListGroupsForUserRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserResponse.ReadOnly
          ] = proxy(AdminListGroupsForUserPaginated, request)
          def deleteUserAttributes(request: DeleteUserAttributesRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.DeleteUserAttributesResponse.ReadOnly
          ] = proxy(DeleteUserAttributes, request)
          def adminResetUserPassword(
              request: AdminResetUserPasswordRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminResetUserPasswordResponse.ReadOnly
          ] = proxy(AdminResetUserPassword, request)
          def addCustomAttributes(request: AddCustomAttributesRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AddCustomAttributesResponse.ReadOnly
          ] = proxy(AddCustomAttributes, request)
          def adminUserGlobalSignOut(
              request: AdminUserGlobalSignOutRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse.ReadOnly
          ] = proxy(AdminUserGlobalSignOut, request)
          def getUICustomization(request: GetUiCustomizationRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.GetUiCustomizationResponse.ReadOnly
          ] = proxy(GetUICustomization, request)
          def createResourceServer(request: CreateResourceServerRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.CreateResourceServerResponse.ReadOnly
          ] = proxy(CreateResourceServer, request)
          def adminDisableUser(request: AdminDisableUserRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminDisableUserResponse.ReadOnly
          ] = proxy(AdminDisableUser, request)
          def respondToAuthChallenge(
              request: RespondToAuthChallengeRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.RespondToAuthChallengeResponse.ReadOnly
          ] = proxy(RespondToAuthChallenge, request)
          def getUser(request: GetUserRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.GetUserResponse.ReadOnly
          ] = proxy(GetUser, request)
          def deleteResourceServer(
              request: DeleteResourceServerRequest
          ): IO[AwsError, Unit] = proxy(DeleteResourceServer, request)
          def listGroups(request: ListGroupsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cognitoidentityprovider.model.GroupType.ReadOnly
          ] = rts.unsafeRun(proxy(ListGroups, request))
          def listGroupsPaginated(request: ListGroupsRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ListGroupsResponse.ReadOnly
          ] = proxy(ListGroupsPaginated, request)
          def listDevices(request: ListDevicesRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ListDevicesResponse.ReadOnly
          ] = proxy(ListDevices, request)
          def verifySoftwareToken(request: VerifySoftwareTokenRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.VerifySoftwareTokenResponse.ReadOnly
          ] = proxy(VerifySoftwareToken, request)
          def adminDisableProviderForUser(
              request: AdminDisableProviderForUserRequest
          ): IO[AwsError, ReadOnly] =
            proxy(AdminDisableProviderForUser, request)
          def forgotPassword(request: ForgotPasswordRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ForgotPasswordResponse.ReadOnly
          ] = proxy(ForgotPassword, request)
          def updateAuthEventFeedback(
              request: UpdateAuthEventFeedbackRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse.ReadOnly
          ] = proxy(UpdateAuthEventFeedback, request)
          def updateIdentityProvider(
              request: UpdateIdentityProviderRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.UpdateIdentityProviderResponse.ReadOnly
          ] = proxy(UpdateIdentityProvider, request)
          def listUserPoolClients(request: ListUserPoolClientsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cognitoidentityprovider.model.UserPoolClientDescription.ReadOnly
          ] = rts.unsafeRun(proxy(ListUserPoolClients, request))
          def listUserPoolClientsPaginated(
              request: ListUserPoolClientsRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ListUserPoolClientsResponse.ReadOnly
          ] = proxy(ListUserPoolClientsPaginated, request)
          def startUserImportJob(request: StartUserImportJobRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.StartUserImportJobResponse.ReadOnly
          ] = proxy(StartUserImportJob, request)
          def updateUserAttributes(request: UpdateUserAttributesRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.UpdateUserAttributesResponse.ReadOnly
          ] = proxy(UpdateUserAttributes, request)
          def adminListUserAuthEvents(
              request: AdminListUserAuthEventsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly
          ] = rts.unsafeRun(proxy(AdminListUserAuthEvents, request))
          def adminListUserAuthEventsPaginated(
              request: AdminListUserAuthEventsRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.ReadOnly
          ] = proxy(AdminListUserAuthEventsPaginated, request)
          def listIdentityProviders(
              request: ListIdentityProvidersRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.cognitoidentityprovider.model.ProviderDescription.ReadOnly
          ] = rts.unsafeRun(proxy(ListIdentityProviders, request))
          def listIdentityProvidersPaginated(
              request: ListIdentityProvidersRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ListIdentityProvidersResponse.ReadOnly
          ] = proxy(ListIdentityProvidersPaginated, request)
          def listUserImportJobs(request: ListUserImportJobsRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ListUserImportJobsResponse.ReadOnly
          ] = proxy(ListUserImportJobs, request)
          def adminCreateUser(request: AdminCreateUserRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminCreateUserResponse.ReadOnly
          ] = proxy(AdminCreateUser, request)
          def adminInitiateAuth(request: AdminInitiateAuthRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminInitiateAuthResponse.ReadOnly
          ] = proxy(AdminInitiateAuth, request)
          def confirmSignUp(request: ConfirmSignUpRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ConfirmSignUpResponse.ReadOnly
          ] = proxy(ConfirmSignUp, request)
          def adminGetDevice(request: AdminGetDeviceRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminGetDeviceResponse.ReadOnly
          ] = proxy(AdminGetDevice, request)
          def adminLinkProviderForUser(
              request: AdminLinkProviderForUserRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserResponse.ReadOnly
          ] = proxy(AdminLinkProviderForUser, request)
          def confirmForgotPassword(request: ConfirmForgotPasswordRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ConfirmForgotPasswordResponse.ReadOnly
          ] = proxy(ConfirmForgotPassword, request)
          def setRiskConfiguration(request: SetRiskConfigurationRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.SetRiskConfigurationResponse.ReadOnly
          ] = proxy(SetRiskConfiguration, request)
          def forgetDevice(request: ForgetDeviceRequest): IO[AwsError, Unit] =
            proxy(ForgetDevice, request)
          def deleteUserPool(
              request: DeleteUserPoolRequest
          ): IO[AwsError, Unit] = proxy(DeleteUserPool, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def listResourceServers(request: ListResourceServersRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cognitoidentityprovider.model.ResourceServerType.ReadOnly
          ] = rts.unsafeRun(proxy(ListResourceServers, request))
          def listResourceServersPaginated(
              request: ListResourceServersRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ListResourceServersResponse.ReadOnly
          ] = proxy(ListResourceServersPaginated, request)
          def describeUserImportJob(request: DescribeUserImportJobRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.DescribeUserImportJobResponse.ReadOnly
          ] = proxy(DescribeUserImportJob, request)
          def deleteUserPoolDomain(request: DeleteUserPoolDomainRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.DeleteUserPoolDomainResponse.ReadOnly
          ] = proxy(DeleteUserPoolDomain, request)
          def setUserSettings(request: SetUserSettingsRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.SetUserSettingsResponse.ReadOnly
          ] = proxy(SetUserSettings, request)
          def adminDeleteUser(
              request: AdminDeleteUserRequest
          ): IO[AwsError, Unit] = proxy(AdminDeleteUser, request)
          def adminRespondToAuthChallenge(
              request: AdminRespondToAuthChallengeRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse.ReadOnly
          ] = proxy(AdminRespondToAuthChallenge, request)
          def createGroup(request: CreateGroupRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.CreateGroupResponse.ReadOnly
          ] = proxy(CreateGroup, request)
          def adminAddUserToGroup(
              request: AdminAddUserToGroupRequest
          ): IO[AwsError, Unit] = proxy(AdminAddUserToGroup, request)
          def adminSetUserPassword(request: AdminSetUserPasswordRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordResponse.ReadOnly
          ] = proxy(AdminSetUserPassword, request)
          def setUserMFAPreference(request: SetUserMfaPreferenceRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.SetUserMfaPreferenceResponse.ReadOnly
          ] = proxy(SetUserMFAPreference, request)
          def updateUserPoolDomain(request: UpdateUserPoolDomainRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainResponse.ReadOnly
          ] = proxy(UpdateUserPoolDomain, request)
          def setUICustomization(request: SetUiCustomizationRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.SetUiCustomizationResponse.ReadOnly
          ] = proxy(SetUICustomization, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def updateGroup(request: UpdateGroupRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.UpdateGroupResponse.ReadOnly
          ] = proxy(UpdateGroup, request)
          def confirmDevice(request: ConfirmDeviceRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ConfirmDeviceResponse.ReadOnly
          ] = proxy(ConfirmDevice, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def adminDeleteUserAttributes(
              request: AdminDeleteUserAttributesRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse.ReadOnly
          ] = proxy(AdminDeleteUserAttributes, request)
          def adminForgetDevice(
              request: AdminForgetDeviceRequest
          ): IO[AwsError, Unit] = proxy(AdminForgetDevice, request)
          def createUserPool(request: CreateUserPoolRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.CreateUserPoolResponse.ReadOnly
          ] = proxy(CreateUserPool, request)
          def deleteUser(request: DeleteUserRequest): IO[AwsError, Unit] =
            proxy(DeleteUser, request)
          def createUserImportJob(request: CreateUserImportJobRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.CreateUserImportJobResponse.ReadOnly
          ] = proxy(CreateUserImportJob, request)
          def getGroup(request: GetGroupRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.GetGroupResponse.ReadOnly
          ] = proxy(GetGroup, request)
          def createUserPoolClient(request: CreateUserPoolClientRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.CreateUserPoolClientResponse.ReadOnly
          ] = proxy(CreateUserPoolClient, request)
          def updateUserPool(request: UpdateUserPoolRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.UpdateUserPoolResponse.ReadOnly
          ] = proxy(UpdateUserPool, request)
          def updateDeviceStatus(request: UpdateDeviceStatusRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusResponse.ReadOnly
          ] = proxy(UpdateDeviceStatus, request)
          def describeUserPoolClient(
              request: DescribeUserPoolClientRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.DescribeUserPoolClientResponse.ReadOnly
          ] = proxy(DescribeUserPoolClient, request)
          def getCSVHeader(request: GetCsvHeaderRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.GetCsvHeaderResponse.ReadOnly
          ] = proxy(GetCSVHeader, request)
          def describeResourceServer(
              request: DescribeResourceServerRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.DescribeResourceServerResponse.ReadOnly
          ] = proxy(DescribeResourceServer, request)
          def setUserPoolMfaConfig(request: SetUserPoolMfaConfigRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse.ReadOnly
          ] = proxy(SetUserPoolMfaConfig, request)
          def describeRiskConfiguration(
              request: DescribeRiskConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.DescribeRiskConfigurationResponse.ReadOnly
          ] = proxy(DescribeRiskConfiguration, request)
          def listUserPools(request: ListUserPoolsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.cognitoidentityprovider.model.UserPoolDescriptionType.ReadOnly
          ] = rts.unsafeRun(proxy(ListUserPools, request))
          def listUserPoolsPaginated(request: ListUserPoolsRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.ListUserPoolsResponse.ReadOnly
          ] = proxy(ListUserPoolsPaginated, request)
          def adminListDevices(request: AdminListDevicesRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminListDevicesResponse.ReadOnly
          ] = proxy(AdminListDevices, request)
          def getDevice(request: GetDeviceRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.GetDeviceResponse.ReadOnly
          ] = proxy(GetDevice, request)
          def adminSetUserMFAPreference(
              request: AdminSetUserMfaPreferenceRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse.ReadOnly
          ] = proxy(AdminSetUserMFAPreference, request)
          def updateResourceServer(request: UpdateResourceServerRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.UpdateResourceServerResponse.ReadOnly
          ] = proxy(UpdateResourceServer, request)
          def verifyUserAttribute(request: VerifyUserAttributeRequest): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.VerifyUserAttributeResponse.ReadOnly
          ] = proxy(VerifyUserAttribute, request)
          def getIdentityProviderByIdentifier(
              request: GetIdentityProviderByIdentifierRequest
          ): IO[
            AwsError,
            zio.aws.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse.ReadOnly
          ] = proxy(GetIdentityProviderByIdentifier, request)
        }
      }
    }
    .toLayer
}
