package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.cognitoidentityprovider.model.primitives.{
  DateType,
  ClientIdType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class RiskConfigurationType(
    userPoolId: Option[UserPoolIdType] = None,
    clientId: Option[ClientIdType] = None,
    compromisedCredentialsRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType
    ] = None,
    accountTakeoverRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType
    ] = None,
    riskExceptionConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType
    ] = None,
    lastModifiedDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.RiskConfigurationType = {
    import RiskConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.RiskConfigurationType
      .builder()
      .optionallyWith(
        userPoolId.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        clientId.map(value => ClientIdType.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        compromisedCredentialsRiskConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.compromisedCredentialsRiskConfiguration)
      .optionallyWith(
        accountTakeoverRiskConfiguration.map(value => value.buildAwsValue())
      )(_.accountTakeoverRiskConfiguration)
      .optionallyWith(
        riskExceptionConfiguration.map(value => value.buildAwsValue())
      )(_.riskExceptionConfiguration)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.RiskConfigurationType
      .wrap(buildAwsValue())
}
object RiskConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.RiskConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.RiskConfigurationType =
      zio.aws.cognitoidentityprovider.model.RiskConfigurationType(
        userPoolId.map(value => value),
        clientId.map(value => value),
        compromisedCredentialsRiskConfiguration.map(value => value.asEditable),
        accountTakeoverRiskConfiguration.map(value => value.asEditable),
        riskExceptionConfiguration.map(value => value.asEditable),
        lastModifiedDate.map(value => value)
      )
    def userPoolId: Option[UserPoolIdType]
    def clientId: Option[ClientIdType]
    def compromisedCredentialsRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly
    ]
    def accountTakeoverRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly
    ]
    def riskExceptionConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly
    ]
    def lastModifiedDate: Option[DateType]
    def getUserPoolId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getClientId: ZIO[Any, AwsError, ClientIdType] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getCompromisedCredentialsRiskConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "compromisedCredentialsRiskConfiguration",
      compromisedCredentialsRiskConfiguration
    )
    def getAccountTakeoverRiskConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountTakeoverRiskConfiguration",
      accountTakeoverRiskConfiguration
    )
    def getRiskExceptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "riskExceptionConfiguration",
      riskExceptionConfiguration
    )
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RiskConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly {
    override val userPoolId: Option[UserPoolIdType] = scala
      .Option(impl.userPoolId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val clientId: Option[ClientIdType] = scala
      .Option(impl.clientId())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ClientIdType(value)
      )
    override val compromisedCredentialsRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType.ReadOnly
    ] = scala
      .Option(impl.compromisedCredentialsRiskConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType
          .wrap(value)
      )
    override val accountTakeoverRiskConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType.ReadOnly
    ] = scala
      .Option(impl.accountTakeoverRiskConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType
          .wrap(value)
      )
    override val riskExceptionConfiguration: Option[
      zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType.ReadOnly
    ] = scala
      .Option(impl.riskExceptionConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.RiskExceptionConfigurationType
          .wrap(value)
      )
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.RiskConfigurationType
  ): zio.aws.cognitoidentityprovider.model.RiskConfigurationType.ReadOnly =
    new Wrapper(impl)
}
