package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  UsernameType,
  UserPoolIdType,
  DeviceKeyType
}
import scala.jdk.CollectionConverters._
final case class AdminGetDeviceRequest(
    deviceKey: DeviceKeyType,
    userPoolId: UserPoolIdType,
    username: UsernameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest = {
    import AdminGetDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest
      .builder()
      .deviceKey(DeviceKeyType.unwrap(deviceKey): java.lang.String)
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminGetDeviceRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminGetDeviceRequest
      .wrap(buildAwsValue())
}
object AdminGetDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminGetDeviceRequest =
      zio.aws.cognitoidentityprovider.model
        .AdminGetDeviceRequest(deviceKey, userPoolId, username)
    def deviceKey: DeviceKeyType
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def getDeviceKey: ZIO[Any, Nothing, DeviceKeyType] = ZIO.succeed(deviceKey)
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminGetDeviceRequest.ReadOnly {
    override val deviceKey: DeviceKeyType =
      zio.aws.cognitoidentityprovider.model.primitives
        .DeviceKeyType(impl.deviceKey())
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest
  ): zio.aws.cognitoidentityprovider.model.AdminGetDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
