package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LogConfigurationType(
    logLevel: zio.aws.cognitoidentityprovider.model.LogLevel,
    eventSource: zio.aws.cognitoidentityprovider.model.EventSourceName,
    cloudWatchLogsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.CloudWatchLogsConfigurationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.LogConfigurationType = {
    import LogConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.LogConfigurationType
      .builder()
      .logLevel(logLevel.unwrap)
      .eventSource(eventSource.unwrap)
      .optionallyWith(
        cloudWatchLogsConfiguration.map(value => value.buildAwsValue())
      )(_.cloudWatchLogsConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.LogConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.LogConfigurationType
      .wrap(buildAwsValue())
}
object LogConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.LogConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.LogConfigurationType =
      zio.aws.cognitoidentityprovider.model.LogConfigurationType(
        logLevel,
        eventSource,
        cloudWatchLogsConfiguration.map(value => value.asEditable)
      )
    def logLevel: zio.aws.cognitoidentityprovider.model.LogLevel
    def eventSource: zio.aws.cognitoidentityprovider.model.EventSourceName
    def cloudWatchLogsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.CloudWatchLogsConfigurationType.ReadOnly
    ]
    def getLogLevel
        : ZIO[Any, Nothing, zio.aws.cognitoidentityprovider.model.LogLevel] =
      ZIO.succeed(logLevel)
    def getEventSource: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.EventSourceName
    ] = ZIO.succeed(eventSource)
    def getCloudWatchLogsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.CloudWatchLogsConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLogsConfiguration",
      cloudWatchLogsConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.LogConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.LogConfigurationType.ReadOnly {
    override val logLevel: zio.aws.cognitoidentityprovider.model.LogLevel =
      zio.aws.cognitoidentityprovider.model.LogLevel.wrap(impl.logLevel())
    override val eventSource
        : zio.aws.cognitoidentityprovider.model.EventSourceName =
      zio.aws.cognitoidentityprovider.model.EventSourceName
        .wrap(impl.eventSource())
    override val cloudWatchLogsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.CloudWatchLogsConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogsConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.CloudWatchLogsConfigurationType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.LogConfigurationType
  ): zio.aws.cognitoidentityprovider.model.LogConfigurationType.ReadOnly =
    new Wrapper(impl)
}
