package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.ArnType
import scala.jdk.CollectionConverters._
final case class CloudWatchLogsConfigurationType(
    logGroupArn: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.CloudWatchLogsConfigurationType = {
    import CloudWatchLogsConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.CloudWatchLogsConfigurationType
      .builder()
      .optionallyWith(
        logGroupArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.logGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.CloudWatchLogsConfigurationType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.CloudWatchLogsConfigurationType
      .wrap(buildAwsValue())
}
object CloudWatchLogsConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.CloudWatchLogsConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.CloudWatchLogsConfigurationType =
      zio.aws.cognitoidentityprovider.model
        .CloudWatchLogsConfigurationType(logGroupArn.map(value => value))
    def logGroupArn: Optional[ArnType]
    def getLogGroupArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("logGroupArn", logGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CloudWatchLogsConfigurationType
  ) extends zio.aws.cognitoidentityprovider.model.CloudWatchLogsConfigurationType.ReadOnly {
    override val logGroupArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroupArn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.CloudWatchLogsConfigurationType
  ): zio.aws.cognitoidentityprovider.model.CloudWatchLogsConfigurationType.ReadOnly =
    new Wrapper(impl)
}
