package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  SessionType,
  StringType,
  ClientIdType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminRespondToAuthChallengeRequest(
    userPoolId: UserPoolIdType,
    clientId: ClientIdType,
    challengeName: zio.aws.cognitoidentityprovider.model.ChallengeNameType,
    challengeResponses: Optional[Map[StringType, StringType]] = Optional.Absent,
    session: Optional[SessionType] = Optional.Absent,
    analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType
    ] = Optional.Absent,
    contextData: Optional[
      zio.aws.cognitoidentityprovider.model.ContextDataType
    ] = Optional.Absent,
    clientMetadata: Optional[Map[StringType, StringType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest = {
    import AdminRespondToAuthChallengeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .clientId(ClientIdType.unwrap(clientId): java.lang.String)
      .challengeName(challengeName.unwrap)
      .optionallyWith(
        challengeResponses.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.challengeResponses)
      .optionallyWith(
        session.map(value => SessionType.unwrap(value): java.lang.String)
      )(_.session)
      .optionallyWith(analyticsMetadata.map(value => value.buildAwsValue()))(
        _.analyticsMetadata
      )
      .optionallyWith(contextData.map(value => value.buildAwsValue()))(
        _.contextData
      )
      .optionallyWith(
        clientMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.clientMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest
      .wrap(buildAwsValue())
}
object AdminRespondToAuthChallengeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest =
      zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest(
        userPoolId,
        clientId,
        challengeName,
        challengeResponses.map(value => value),
        session.map(value => value),
        analyticsMetadata.map(value => value.asEditable),
        contextData.map(value => value.asEditable),
        clientMetadata.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def clientId: ClientIdType
    def challengeName: zio.aws.cognitoidentityprovider.model.ChallengeNameType
    def challengeResponses: Optional[Map[StringType, StringType]]
    def session: Optional[SessionType]
    def analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ]
    def contextData: Optional[
      zio.aws.cognitoidentityprovider.model.ContextDataType.ReadOnly
    ]
    def clientMetadata: Optional[Map[StringType, StringType]]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getClientId: ZIO[Any, Nothing, ClientIdType] = ZIO.succeed(clientId)
    def getChallengeName: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.ChallengeNameType
    ] = ZIO.succeed(challengeName)
    def getChallengeResponses: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("challengeResponses", challengeResponses)
    def getSession: ZIO[Any, AwsError, SessionType] =
      AwsError.unwrapOptionField("session", session)
    def getAnalyticsMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = AwsError.unwrapOptionField("analyticsMetadata", analyticsMetadata)
    def getContextData: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.ContextDataType.ReadOnly
    ] = AwsError.unwrapOptionField("contextData", contextData)
    def getClientMetadata: ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField("clientMetadata", clientMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val clientId: ClientIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ClientIdType(impl.clientId())
    override val challengeName
        : zio.aws.cognitoidentityprovider.model.ChallengeNameType =
      zio.aws.cognitoidentityprovider.model.ChallengeNameType
        .wrap(impl.challengeName())
    override val challengeResponses: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.challengeResponses())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
    override val session: Optional[SessionType] = zio.aws.core.internal
      .optionalFromNullable(impl.session())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.SessionType(value)
      )
    override val analyticsMetadata: Optional[
      zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.analyticsMetadata())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AnalyticsMetadataType.wrap(value)
      )
    override val contextData: Optional[
      zio.aws.cognitoidentityprovider.model.ContextDataType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contextData())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.ContextDataType.wrap(value)
      )
    override val clientMetadata: Optional[Map[StringType, StringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest
  ): zio.aws.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest.ReadOnly =
    new Wrapper(impl)
}
