package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait RiskDecisionType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType
}
object RiskDecisionType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType
  ): zio.aws.cognitoidentityprovider.model.RiskDecisionType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType.NO_RISK =>
      val r = NoRisk
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType.ACCOUNT_TAKEOVER =>
      val r = AccountTakeover
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType.BLOCK =>
      val r = Block
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.RiskDecisionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType.UNKNOWN_TO_SDK_VERSION
  }
  case object NoRisk
      extends zio.aws.cognitoidentityprovider.model.RiskDecisionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType.NO_RISK
  }
  case object AccountTakeover
      extends zio.aws.cognitoidentityprovider.model.RiskDecisionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType.ACCOUNT_TAKEOVER
  }
  case object Block
      extends zio.aws.cognitoidentityprovider.model.RiskDecisionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.RiskDecisionType.BLOCK
  }
}
