package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class GetSigningCertificateResponse(
    certificate: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse = {
    import GetSigningCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse
      .builder()
      .optionallyWith(certificate.map(value => value: java.lang.String))(
        _.certificate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse
      .wrap(buildAwsValue())
}
object GetSigningCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse =
      zio.aws.cognitoidentityprovider.model
        .GetSigningCertificateResponse(certificate.map(value => value))
    def certificate: Optional[StringType]
    def getCertificate: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("certificate", certificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse
  ) extends zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.ReadOnly {
    override val certificate: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.certificate())
      .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse
  ): zio.aws.cognitoidentityprovider.model.GetSigningCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
