package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  PaginationKey,
  QueryLimitType,
  UserPoolIdType,
  UsernameType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AdminListGroupsForUserRequest(
    username: UsernameType,
    userPoolId: UserPoolIdType,
    limit: Optional[QueryLimitType] = Optional.Absent,
    nextToken: Optional[PaginationKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest = {
    import AdminListGroupsForUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest
      .builder()
      .username(UsernameType.unwrap(username): java.lang.String)
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(
        limit.map(value => QueryLimitType.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserRequest
      .wrap(buildAwsValue())
}
object AdminListGroupsForUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserRequest =
      zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserRequest(
        username,
        userPoolId,
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def username: UsernameType
    def userPoolId: UserPoolIdType
    def limit: Optional[QueryLimitType]
    def nextToken: Optional[PaginationKey]
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getLimit: ZIO[Any, AwsError, QueryLimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserRequest.ReadOnly {
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val limit: Optional[QueryLimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.QueryLimitType(value)
      )
    override val nextToken: Optional[PaginationKey] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest
  ): zio.aws.cognitoidentityprovider.model.AdminListGroupsForUserRequest.ReadOnly =
    new Wrapper(impl)
}
