package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  BooleanType,
  PasswordType,
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminSetUserPasswordRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    password: PasswordType,
    permanent: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest = {
    import AdminSetUserPasswordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .password(PasswordType.unwrap(password): java.lang.String)
      .optionallyWith(
        permanent.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.permanent)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordRequest
      .wrap(buildAwsValue())
}
object AdminSetUserPasswordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordRequest =
      zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordRequest(
        userPoolId,
        username,
        password,
        permanent.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def password: PasswordType
    def permanent: Optional[BooleanType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getPassword: ZIO[Any, Nothing, PasswordType] = ZIO.succeed(password)
    def getPermanent: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("permanent", permanent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val password: PasswordType =
      zio.aws.cognitoidentityprovider.model.primitives
        .PasswordType(impl.password())
    override val permanent: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.permanent())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.BooleanType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest
  ): zio.aws.cognitoidentityprovider.model.AdminSetUserPasswordRequest.ReadOnly =
    new Wrapper(impl)
}
