package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  DeviceKeyType,
  TokenModelType
}
import scala.jdk.CollectionConverters._
final case class UpdateDeviceStatusRequest(
    accessToken: TokenModelType,
    deviceKey: DeviceKeyType,
    deviceRememberedStatus: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest = {
    import UpdateDeviceStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest
      .builder()
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .deviceKey(DeviceKeyType.unwrap(deviceKey): java.lang.String)
      .optionallyWith(deviceRememberedStatus.map(value => value.unwrap))(
        _.deviceRememberedStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusRequest
      .wrap(buildAwsValue())
}
object UpdateDeviceStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusRequest =
      zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusRequest(
        accessToken,
        deviceKey,
        deviceRememberedStatus.map(value => value)
      )
    def accessToken: TokenModelType
    def deviceKey: DeviceKeyType
    def deviceRememberedStatus: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType
    ]
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
    def getDeviceKey: ZIO[Any, Nothing, DeviceKeyType] = ZIO.succeed(deviceKey)
    def getDeviceRememberedStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType
    ] = AwsError.unwrapOptionField(
      "deviceRememberedStatus",
      deviceRememberedStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest
  ) extends zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusRequest.ReadOnly {
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
    override val deviceKey: DeviceKeyType =
      zio.aws.cognitoidentityprovider.model.primitives
        .DeviceKeyType(impl.deviceKey())
    override val deviceRememberedStatus: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceRememberedStatus())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.DeviceRememberedStatusType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest
  ): zio.aws.cognitoidentityprovider.model.UpdateDeviceStatusRequest.ReadOnly =
    new Wrapper(impl)
}
