package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait LogLevel {
  def unwrap
      : software.amazon.awssdk.services.cognitoidentityprovider.model.LogLevel
}
object LogLevel {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.LogLevel
  ): zio.aws.cognitoidentityprovider.model.LogLevel = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.LogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.LogLevel.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.LogLevel =
      software.amazon.awssdk.services.cognitoidentityprovider.model.LogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object ERROR extends zio.aws.cognitoidentityprovider.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.LogLevel =
      software.amazon.awssdk.services.cognitoidentityprovider.model.LogLevel.ERROR
  }
}
