package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait EventSourceName {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.EventSourceName
}
object EventSourceName {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.EventSourceName
  ): zio.aws.cognitoidentityprovider.model.EventSourceName = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventSourceName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.EventSourceName.USER_NOTIFICATION =>
      val r = userNotification
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.EventSourceName {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventSourceName =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventSourceName.UNKNOWN_TO_SDK_VERSION
  }
  case object userNotification
      extends zio.aws.cognitoidentityprovider.model.EventSourceName {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.EventSourceName =
      software.amazon.awssdk.services.cognitoidentityprovider.model.EventSourceName.USER_NOTIFICATION
  }
}
