package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait AuthFlowType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType
}
object AuthFlowType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType
  ): zio.aws.cognitoidentityprovider.model.AuthFlowType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.USER_SRP_AUTH =>
      val r = USER_SRP_AUTH
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.REFRESH_TOKEN_AUTH =>
      val r = REFRESH_TOKEN_AUTH
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.REFRESH_TOKEN =>
      val r = REFRESH_TOKEN
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.CUSTOM_AUTH =>
      val r = CUSTOM_AUTH
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.ADMIN_NO_SRP_AUTH =>
      val r = ADMIN_NO_SRP_AUTH
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.USER_PASSWORD_AUTH =>
      val r = USER_PASSWORD_AUTH
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.ADMIN_USER_PASSWORD_AUTH =>
      val r = ADMIN_USER_PASSWORD_AUTH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.AuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER_SRP_AUTH
      extends zio.aws.cognitoidentityprovider.model.AuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.USER_SRP_AUTH
  }
  case object REFRESH_TOKEN_AUTH
      extends zio.aws.cognitoidentityprovider.model.AuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.REFRESH_TOKEN_AUTH
  }
  case object REFRESH_TOKEN
      extends zio.aws.cognitoidentityprovider.model.AuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.REFRESH_TOKEN
  }
  case object CUSTOM_AUTH
      extends zio.aws.cognitoidentityprovider.model.AuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.CUSTOM_AUTH
  }
  case object ADMIN_NO_SRP_AUTH
      extends zio.aws.cognitoidentityprovider.model.AuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.ADMIN_NO_SRP_AUTH
  }
  case object USER_PASSWORD_AUTH
      extends zio.aws.cognitoidentityprovider.model.AuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.USER_PASSWORD_AUTH
  }
  case object ADMIN_USER_PASSWORD_AUTH
      extends zio.aws.cognitoidentityprovider.model.AuthFlowType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType.ADMIN_USER_PASSWORD_AUTH
  }
}
