package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.{
  EmailVerificationMessageType,
  SmsVerificationMessageType,
  EmailVerificationSubjectType,
  UserPoolIdType,
  TagKeysType,
  TagValueType
}
import scala.jdk.CollectionConverters._
final case class UpdateUserPoolRequest(
    userPoolId: UserPoolIdType,
    policies: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType
    ] = Optional.Absent,
    deletionProtection: Optional[
      zio.aws.cognitoidentityprovider.model.DeletionProtectionType
    ] = Optional.Absent,
    lambdaConfig: Optional[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType
    ] = Optional.Absent,
    autoVerifiedAttributes: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ] = Optional.Absent,
    smsVerificationMessage: Optional[SmsVerificationMessageType] =
      Optional.Absent,
    emailVerificationMessage: Optional[EmailVerificationMessageType] =
      Optional.Absent,
    emailVerificationSubject: Optional[EmailVerificationSubjectType] =
      Optional.Absent,
    verificationMessageTemplate: Optional[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType
    ] = Optional.Absent,
    smsAuthenticationMessage: Optional[SmsVerificationMessageType] =
      Optional.Absent,
    userAttributeUpdateSettings: Optional[
      zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType
    ] = Optional.Absent,
    mfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = Optional.Absent,
    deviceConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType
    ] = Optional.Absent,
    emailConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType
    ] = Optional.Absent,
    smsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType
    ] = Optional.Absent,
    userPoolTags: Optional[Map[TagKeysType, TagValueType]] = Optional.Absent,
    adminCreateUserConfig: Optional[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType
    ] = Optional.Absent,
    userPoolAddOns: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType
    ] = Optional.Absent,
    accountRecoverySetting: Optional[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest = {
    import UpdateUserPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .optionallyWith(policies.map(value => value.buildAwsValue()))(_.policies)
      .optionallyWith(deletionProtection.map(value => value.unwrap))(
        _.deletionProtection
      )
      .optionallyWith(lambdaConfig.map(value => value.buildAwsValue()))(
        _.lambdaConfig
      )
      .optionallyWith(
        autoVerifiedAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.autoVerifiedAttributesWithStrings)
      .optionallyWith(
        smsVerificationMessage.map(value =>
          SmsVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.smsVerificationMessage)
      .optionallyWith(
        emailVerificationMessage.map(value =>
          EmailVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.emailVerificationMessage)
      .optionallyWith(
        emailVerificationSubject.map(value =>
          EmailVerificationSubjectType.unwrap(value): java.lang.String
        )
      )(_.emailVerificationSubject)
      .optionallyWith(
        verificationMessageTemplate.map(value => value.buildAwsValue())
      )(_.verificationMessageTemplate)
      .optionallyWith(
        smsAuthenticationMessage.map(value =>
          SmsVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.smsAuthenticationMessage)
      .optionallyWith(
        userAttributeUpdateSettings.map(value => value.buildAwsValue())
      )(_.userAttributeUpdateSettings)
      .optionallyWith(mfaConfiguration.map(value => value.unwrap))(
        _.mfaConfiguration
      )
      .optionallyWith(deviceConfiguration.map(value => value.buildAwsValue()))(
        _.deviceConfiguration
      )
      .optionallyWith(emailConfiguration.map(value => value.buildAwsValue()))(
        _.emailConfiguration
      )
      .optionallyWith(smsConfiguration.map(value => value.buildAwsValue()))(
        _.smsConfiguration
      )
      .optionallyWith(
        userPoolTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKeysType.unwrap(key): java.lang.String) -> (TagValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.userPoolTags)
      .optionallyWith(
        adminCreateUserConfig.map(value => value.buildAwsValue())
      )(_.adminCreateUserConfig)
      .optionallyWith(userPoolAddOns.map(value => value.buildAwsValue()))(
        _.userPoolAddOns
      )
      .optionallyWith(
        accountRecoverySetting.map(value => value.buildAwsValue())
      )(_.accountRecoverySetting)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UpdateUserPoolRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UpdateUserPoolRequest
      .wrap(buildAwsValue())
}
object UpdateUserPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UpdateUserPoolRequest =
      zio.aws.cognitoidentityprovider.model.UpdateUserPoolRequest(
        userPoolId,
        policies.map(value => value.asEditable),
        deletionProtection.map(value => value),
        lambdaConfig.map(value => value.asEditable),
        autoVerifiedAttributes.map(value => value),
        smsVerificationMessage.map(value => value),
        emailVerificationMessage.map(value => value),
        emailVerificationSubject.map(value => value),
        verificationMessageTemplate.map(value => value.asEditable),
        smsAuthenticationMessage.map(value => value),
        userAttributeUpdateSettings.map(value => value.asEditable),
        mfaConfiguration.map(value => value),
        deviceConfiguration.map(value => value.asEditable),
        emailConfiguration.map(value => value.asEditable),
        smsConfiguration.map(value => value.asEditable),
        userPoolTags.map(value => value),
        adminCreateUserConfig.map(value => value.asEditable),
        userPoolAddOns.map(value => value.asEditable),
        accountRecoverySetting.map(value => value.asEditable)
      )
    def userPoolId: UserPoolIdType
    def policies: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ]
    def deletionProtection
        : Optional[zio.aws.cognitoidentityprovider.model.DeletionProtectionType]
    def lambdaConfig: Optional[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ]
    def autoVerifiedAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ]
    def smsVerificationMessage: Optional[SmsVerificationMessageType]
    def emailVerificationMessage: Optional[EmailVerificationMessageType]
    def emailVerificationSubject: Optional[EmailVerificationSubjectType]
    def verificationMessageTemplate: Optional[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ]
    def smsAuthenticationMessage: Optional[SmsVerificationMessageType]
    def userAttributeUpdateSettings: Optional[
      zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.ReadOnly
    ]
    def mfaConfiguration
        : Optional[zio.aws.cognitoidentityprovider.model.UserPoolMfaType]
    def deviceConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ]
    def emailConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ]
    def smsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ]
    def userPoolTags: Optional[Map[TagKeysType, TagValueType]]
    def adminCreateUserConfig: Optional[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ]
    def userPoolAddOns: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ]
    def accountRecoverySetting: Optional[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ] = AwsError.unwrapOptionField("policies", policies)
    def getDeletionProtection: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeletionProtectionType
    ] = AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getLambdaConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaConfig", lambdaConfig)
    def getAutoVerifiedAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.VerifiedAttributeType
    ]] = AwsError.unwrapOptionField(
      "autoVerifiedAttributes",
      autoVerifiedAttributes
    )
    def getSmsVerificationMessage
        : ZIO[Any, AwsError, SmsVerificationMessageType] = AwsError
      .unwrapOptionField("smsVerificationMessage", smsVerificationMessage)
    def getEmailVerificationMessage
        : ZIO[Any, AwsError, EmailVerificationMessageType] = AwsError
      .unwrapOptionField("emailVerificationMessage", emailVerificationMessage)
    def getEmailVerificationSubject
        : ZIO[Any, AwsError, EmailVerificationSubjectType] = AwsError
      .unwrapOptionField("emailVerificationSubject", emailVerificationSubject)
    def getVerificationMessageTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verificationMessageTemplate",
      verificationMessageTemplate
    )
    def getSmsAuthenticationMessage
        : ZIO[Any, AwsError, SmsVerificationMessageType] = AwsError
      .unwrapOptionField("smsAuthenticationMessage", smsAuthenticationMessage)
    def getUserAttributeUpdateSettings: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "userAttributeUpdateSettings",
      userAttributeUpdateSettings
    )
    def getMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = AwsError.unwrapOptionField("mfaConfiguration", mfaConfiguration)
    def getDeviceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("deviceConfiguration", deviceConfiguration)
    def getEmailConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("emailConfiguration", emailConfiguration)
    def getSmsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("smsConfiguration", smsConfiguration)
    def getUserPoolTags: ZIO[Any, AwsError, Map[TagKeysType, TagValueType]] =
      AwsError.unwrapOptionField("userPoolTags", userPoolTags)
    def getAdminCreateUserConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ] =
      AwsError.unwrapOptionField("adminCreateUserConfig", adminCreateUserConfig)
    def getUserPoolAddOns: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ] = AwsError.unwrapOptionField("userPoolAddOns", userPoolAddOns)
    def getAccountRecoverySetting: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountRecoverySetting",
      accountRecoverySetting
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest
  ) extends zio.aws.cognitoidentityprovider.model.UpdateUserPoolRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val policies: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.policies())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.wrap(value)
      )
    override val deletionProtection: Optional[
      zio.aws.cognitoidentityprovider.model.DeletionProtectionType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionProtection())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.DeletionProtectionType.wrap(value)
      )
    override val lambdaConfig: Optional[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.LambdaConfigType.wrap(value)
      )
    override val autoVerifiedAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.autoVerifiedAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.VerifiedAttributeType.wrap(item)
        }.toList
      )
    override val smsVerificationMessage: Optional[SmsVerificationMessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smsVerificationMessage())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .SmsVerificationMessageType(value)
        )
    override val emailVerificationMessage
        : Optional[EmailVerificationMessageType] = zio.aws.core.internal
      .optionalFromNullable(impl.emailVerificationMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationMessageType(value)
      )
    override val emailVerificationSubject
        : Optional[EmailVerificationSubjectType] = zio.aws.core.internal
      .optionalFromNullable(impl.emailVerificationSubject())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationSubjectType(value)
      )
    override val verificationMessageTemplate: Optional[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.verificationMessageTemplate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType
          .wrap(value)
      )
    override val smsAuthenticationMessage
        : Optional[SmsVerificationMessageType] = zio.aws.core.internal
      .optionalFromNullable(impl.smsAuthenticationMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .SmsVerificationMessageType(value)
      )
    override val userAttributeUpdateSettings: Optional[
      zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userAttributeUpdateSettings())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType
          .wrap(value)
      )
    override val mfaConfiguration
        : Optional[zio.aws.cognitoidentityprovider.model.UserPoolMfaType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mfaConfiguration())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.UserPoolMfaType.wrap(value)
        )
    override val deviceConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.DeviceConfigurationType
          .wrap(value)
      )
    override val emailConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.emailConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.EmailConfigurationType.wrap(value)
      )
    override val smsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.smsConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SmsConfigurationType.wrap(value)
      )
    override val userPoolTags: Optional[Map[TagKeysType, TagValueType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userPoolTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentityprovider.model.primitives.TagKeysType(
                key
              ) -> zio.aws.cognitoidentityprovider.model.primitives
                .TagValueType(value)
            })
            .toMap
        )
    override val adminCreateUserConfig: Optional[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.adminCreateUserConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType
          .wrap(value)
      )
    override val userPoolAddOns: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolAddOns())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.wrap(value)
      )
    override val accountRecoverySetting: Optional[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountRecoverySetting())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest
  ): zio.aws.cognitoidentityprovider.model.UpdateUserPoolRequest.ReadOnly =
    new Wrapper(impl)
}
