package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class NumberAttributeConstraintsType(
    minValue: Optional[StringType] = Optional.Absent,
    maxValue: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType = {
    import NumberAttributeConstraintsType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType
      .builder()
      .optionallyWith(minValue.map(value => value: java.lang.String))(
        _.minValue
      )
      .optionallyWith(maxValue.map(value => value: java.lang.String))(
        _.maxValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType
      .wrap(buildAwsValue())
}
object NumberAttributeConstraintsType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType =
      zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType(
        minValue.map(value => value),
        maxValue.map(value => value)
      )
    def minValue: Optional[StringType]
    def maxValue: Optional[StringType]
    def getMinValue: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getMaxValue: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("maxValue", maxValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType
  ) extends zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType.ReadOnly {
    override val minValue: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.minValue())
      .map(value => value: StringType)
    override val maxValue: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxValue())
      .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.NumberAttributeConstraintsType
  ): zio.aws.cognitoidentityprovider.model.NumberAttributeConstraintsType.ReadOnly =
    new Wrapper(impl)
}
