package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetLogDeliveryConfigurationResponse(
    logDeliveryConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse = {
    import SetLogDeliveryConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse
      .builder()
      .optionallyWith(
        logDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.logDeliveryConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse
      .wrap(buildAwsValue())
}
object SetLogDeliveryConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse =
      zio.aws.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse(
        logDeliveryConfiguration.map(value => value.asEditable)
      )
    def logDeliveryConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType.ReadOnly
    ]
    def getLogDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "logDeliveryConfiguration",
      logDeliveryConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse
  ) extends zio.aws.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse.ReadOnly {
    override val logDeliveryConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logDeliveryConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.LogDeliveryConfigurationType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse
  ): zio.aws.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
