package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.TokenModelType
import scala.jdk.CollectionConverters._
final case class GetUserRequest(accessToken: TokenModelType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest = {
    import GetUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest
      .builder()
      .accessToken(TokenModelType.unwrap(accessToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.GetUserRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.GetUserRequest.wrap(buildAwsValue())
}
object GetUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.GetUserRequest =
      zio.aws.cognitoidentityprovider.model.GetUserRequest(accessToken)
    def accessToken: TokenModelType
    def getAccessToken: ZIO[Any, Nothing, TokenModelType] =
      ZIO.succeed(accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest
  ) extends zio.aws.cognitoidentityprovider.model.GetUserRequest.ReadOnly {
    override val accessToken: TokenModelType =
      zio.aws.cognitoidentityprovider.model.primitives
        .TokenModelType(impl.accessToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest
  ): zio.aws.cognitoidentityprovider.model.GetUserRequest.ReadOnly =
    new Wrapper(impl)
}
