package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait UserStatusType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType
}
object UserStatusType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType
  ): zio.aws.cognitoidentityprovider.model.UserStatusType = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.UNCONFIRMED =>
      val r = UNCONFIRMED
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.CONFIRMED =>
      val r = CONFIRMED
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.ARCHIVED =>
      val r = ARCHIVED
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.COMPROMISED =>
      val r = COMPROMISED
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.UNKNOWN =>
      val r = UNKNOWN
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.RESET_REQUIRED =>
      val r = RESET_REQUIRED
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.FORCE_CHANGE_PASSWORD =>
      val r = FORCE_CHANGE_PASSWORD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object UNCONFIRMED
      extends zio.aws.cognitoidentityprovider.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.UNCONFIRMED
  }
  case object CONFIRMED
      extends zio.aws.cognitoidentityprovider.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.CONFIRMED
  }
  case object ARCHIVED
      extends zio.aws.cognitoidentityprovider.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.ARCHIVED
  }
  case object COMPROMISED
      extends zio.aws.cognitoidentityprovider.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.COMPROMISED
  }
  case object UNKNOWN
      extends zio.aws.cognitoidentityprovider.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.UNKNOWN
  }
  case object RESET_REQUIRED
      extends zio.aws.cognitoidentityprovider.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.RESET_REQUIRED
  }
  case object FORCE_CHANGE_PASSWORD
      extends zio.aws.cognitoidentityprovider.model.UserStatusType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType.FORCE_CHANGE_PASSWORD
  }
}
