package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  UsernameType,
  UserPoolIdType
}
import scala.jdk.CollectionConverters._
final case class AdminSetUserSettingsRequest(
    userPoolId: UserPoolIdType,
    username: UsernameType,
    mfaOptions: Iterable[zio.aws.cognitoidentityprovider.model.MFAOptionType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest = {
    import AdminSetUserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .username(UsernameType.unwrap(username): java.lang.String)
      .mfaOptions(mfaOptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsRequest
      .wrap(buildAwsValue())
}
object AdminSetUserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsRequest =
      zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsRequest(
        userPoolId,
        username,
        mfaOptions.map { item =>
          item.asEditable
        }
      )
    def userPoolId: UserPoolIdType
    def username: UsernameType
    def mfaOptions
        : List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getMfaOptions: ZIO[Any, Nothing, List[
      zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly
    ]] = ZIO.succeed(mfaOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val username: UsernameType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UsernameType(impl.username())
    override val mfaOptions
        : List[zio.aws.cognitoidentityprovider.model.MFAOptionType.ReadOnly] =
      impl
        .mfaOptions()
        .asScala
        .map { item =>
          zio.aws.cognitoidentityprovider.model.MFAOptionType.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest
  ): zio.aws.cognitoidentityprovider.model.AdminSetUserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
