package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class HttpHeader(
    headerName: Optional[StringType] = Optional.Absent,
    headerValue: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.HttpHeader = {
    import HttpHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.HttpHeader
      .builder()
      .optionallyWith(headerName.map(value => value: java.lang.String))(
        _.headerName
      )
      .optionallyWith(headerValue.map(value => value: java.lang.String))(
        _.headerValue
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.HttpHeader.ReadOnly =
    zio.aws.cognitoidentityprovider.model.HttpHeader.wrap(buildAwsValue())
}
object HttpHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.HttpHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.HttpHeader =
      zio.aws.cognitoidentityprovider.model.HttpHeader(
        headerName.map(value => value),
        headerValue.map(value => value)
      )
    def headerName: Optional[StringType]
    def headerValue: Optional[StringType]
    def getHeaderName: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("headerName", headerName)
    def getHeaderValue: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("headerValue", headerValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.HttpHeader
  ) extends zio.aws.cognitoidentityprovider.model.HttpHeader.ReadOnly {
    override val headerName: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.headerName())
      .map(value => value: StringType)
    override val headerValue: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.headerValue())
      .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.HttpHeader
  ): zio.aws.cognitoidentityprovider.model.HttpHeader.ReadOnly = new Wrapper(
    impl
  )
}
