package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  UserPoolIdType,
  DomainType
}
import scala.jdk.CollectionConverters._
final case class DeleteUserPoolDomainRequest(
    domain: DomainType,
    userPoolId: UserPoolIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest = {
    import DeleteUserPoolDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest
      .builder()
      .domain(DomainType.unwrap(domain): java.lang.String)
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.DeleteUserPoolDomainRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.DeleteUserPoolDomainRequest
      .wrap(buildAwsValue())
}
object DeleteUserPoolDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.DeleteUserPoolDomainRequest =
      zio.aws.cognitoidentityprovider.model
        .DeleteUserPoolDomainRequest(domain, userPoolId)
    def domain: DomainType
    def userPoolId: UserPoolIdType
    def getDomain: ZIO[Any, Nothing, DomainType] = ZIO.succeed(domain)
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest
  ) extends zio.aws.cognitoidentityprovider.model.DeleteUserPoolDomainRequest.ReadOnly {
    override val domain: DomainType =
      zio.aws.cognitoidentityprovider.model.primitives.DomainType(impl.domain())
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest
  ): zio.aws.cognitoidentityprovider.model.DeleteUserPoolDomainRequest.ReadOnly =
    new Wrapper(impl)
}
