package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.StringType
import scala.jdk.CollectionConverters._
final case class AdminLinkProviderForUserRequest(
    userPoolId: StringType,
    destinationUser: zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType,
    sourceUser: zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest = {
    import AdminLinkProviderForUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest
      .builder()
      .userPoolId(userPoolId: java.lang.String)
      .destinationUser(destinationUser.buildAwsValue())
      .sourceUser(sourceUser.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserRequest
      .wrap(buildAwsValue())
}
object AdminLinkProviderForUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserRequest =
      zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserRequest(
        userPoolId,
        destinationUser.asEditable,
        sourceUser.asEditable
      )
    def userPoolId: StringType
    def destinationUser
        : zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly
    def sourceUser
        : zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly
    def getUserPoolId: ZIO[Any, Nothing, StringType] = ZIO.succeed(userPoolId)
    def getDestinationUser: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly
    ] = ZIO.succeed(destinationUser)
    def getSourceUser: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly
    ] = ZIO.succeed(sourceUser)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest
  ) extends zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserRequest.ReadOnly {
    override val userPoolId: StringType = impl.userPoolId(): StringType
    override val destinationUser
        : zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType
        .wrap(impl.destinationUser())
    override val sourceUser
        : zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.ProviderUserIdentifierType
        .wrap(impl.sourceUser())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest
  ): zio.aws.cognitoidentityprovider.model.AdminLinkProviderForUserRequest.ReadOnly =
    new Wrapper(impl)
}
