package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cognitoidentityprovider.model.primitives.PaginationKey
import scala.jdk.CollectionConverters._
final case class AdminListUserAuthEventsResponse(
    authEvents: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.AuthEventType]
    ] = Optional.Absent,
    nextToken: Optional[PaginationKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse = {
    import AdminListUserAuthEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
      .builder()
      .optionallyWith(
        authEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.authEvents)
      .optionallyWith(
        nextToken.map(value => PaginationKey.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.ReadOnly =
    zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
      .wrap(buildAwsValue())
}
object AdminListUserAuthEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse =
      zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse(
        authEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def authEvents: Optional[
      List[zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly]
    ]
    def nextToken: Optional[PaginationKey]
    def getAuthEvents: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly
    ]] = AwsError.unwrapOptionField("authEvents", authEvents)
    def getNextToken: ZIO[Any, AwsError, PaginationKey] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
  ) extends zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.ReadOnly {
    override val authEvents: Optional[
      List[zio.aws.cognitoidentityprovider.model.AuthEventType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.authEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AuthEventType.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationKey] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.PaginationKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
  ): zio.aws.cognitoidentityprovider.model.AdminListUserAuthEventsResponse.ReadOnly =
    new Wrapper(impl)
}
