package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait AccountTakeoverEventActionType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType
}
object AccountTakeoverEventActionType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType
  ): zio.aws.cognitoidentityprovider.model.AccountTakeoverEventActionType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType.BLOCK =>
        val r = BLOCK
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType.MFA_IF_CONFIGURED =>
        val r = MFA_IF_CONFIGURED
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType.MFA_REQUIRED =>
        val r = MFA_REQUIRED
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType.NO_ACTION =>
        val r = NO_ACTION
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.AccountTakeoverEventActionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object BLOCK
      extends zio.aws.cognitoidentityprovider.model.AccountTakeoverEventActionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType.BLOCK
  }
  case object MFA_IF_CONFIGURED
      extends zio.aws.cognitoidentityprovider.model.AccountTakeoverEventActionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType.MFA_IF_CONFIGURED
  }
  case object MFA_REQUIRED
      extends zio.aws.cognitoidentityprovider.model.AccountTakeoverEventActionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType.MFA_REQUIRED
  }
  case object NO_ACTION
      extends zio.aws.cognitoidentityprovider.model.AccountTakeoverEventActionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.AccountTakeoverEventActionType.NO_ACTION
  }
}
