package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  ArnType,
  EmailVerificationMessageType,
  SmsVerificationMessageType,
  EmailVerificationSubjectType,
  UserPoolNameType,
  DateType,
  UserPoolIdType,
  TagKeysType,
  IntegerType,
  StringType,
  TagValueType,
  DomainType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UserPoolType(
    id: Optional[UserPoolIdType] = Optional.Absent,
    name: Optional[UserPoolNameType] = Optional.Absent,
    policies: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType
    ] = Optional.Absent,
    deletionProtection: Optional[
      zio.aws.cognitoidentityprovider.model.DeletionProtectionType
    ] = Optional.Absent,
    lambdaConfig: Optional[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType
    ] = Optional.Absent,
    status: Optional[zio.aws.cognitoidentityprovider.model.StatusType] =
      Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    schemaAttributes: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.SchemaAttributeType]
    ] = Optional.Absent,
    autoVerifiedAttributes: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ] = Optional.Absent,
    aliasAttributes: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.AliasAttributeType]
    ] = Optional.Absent,
    usernameAttributes: Optional[
      Iterable[zio.aws.cognitoidentityprovider.model.UsernameAttributeType]
    ] = Optional.Absent,
    smsVerificationMessage: Optional[SmsVerificationMessageType] =
      Optional.Absent,
    emailVerificationMessage: Optional[EmailVerificationMessageType] =
      Optional.Absent,
    emailVerificationSubject: Optional[EmailVerificationSubjectType] =
      Optional.Absent,
    verificationMessageTemplate: Optional[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType
    ] = Optional.Absent,
    smsAuthenticationMessage: Optional[SmsVerificationMessageType] =
      Optional.Absent,
    userAttributeUpdateSettings: Optional[
      zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType
    ] = Optional.Absent,
    mfaConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = Optional.Absent,
    deviceConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType
    ] = Optional.Absent,
    estimatedNumberOfUsers: Optional[IntegerType] = Optional.Absent,
    emailConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType
    ] = Optional.Absent,
    smsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType
    ] = Optional.Absent,
    userPoolTags: Optional[Map[TagKeysType, TagValueType]] = Optional.Absent,
    smsConfigurationFailure: Optional[StringType] = Optional.Absent,
    emailConfigurationFailure: Optional[StringType] = Optional.Absent,
    domain: Optional[DomainType] = Optional.Absent,
    customDomain: Optional[DomainType] = Optional.Absent,
    adminCreateUserConfig: Optional[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType
    ] = Optional.Absent,
    userPoolAddOns: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType
    ] = Optional.Absent,
    usernameConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType
    ] = Optional.Absent,
    arn: Optional[ArnType] = Optional.Absent,
    accountRecoverySetting: Optional[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType = {
    import UserPoolType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType
      .builder()
      .optionallyWith(
        id.map(value => UserPoolIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => UserPoolNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(policies.map(value => value.buildAwsValue()))(_.policies)
      .optionallyWith(deletionProtection.map(value => value.unwrap))(
        _.deletionProtection
      )
      .optionallyWith(lambdaConfig.map(value => value.buildAwsValue()))(
        _.lambdaConfig
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        schemaAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemaAttributes)
      .optionallyWith(
        autoVerifiedAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.autoVerifiedAttributesWithStrings)
      .optionallyWith(
        aliasAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.aliasAttributesWithStrings)
      .optionallyWith(
        usernameAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.usernameAttributesWithStrings)
      .optionallyWith(
        smsVerificationMessage.map(value =>
          SmsVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.smsVerificationMessage)
      .optionallyWith(
        emailVerificationMessage.map(value =>
          EmailVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.emailVerificationMessage)
      .optionallyWith(
        emailVerificationSubject.map(value =>
          EmailVerificationSubjectType.unwrap(value): java.lang.String
        )
      )(_.emailVerificationSubject)
      .optionallyWith(
        verificationMessageTemplate.map(value => value.buildAwsValue())
      )(_.verificationMessageTemplate)
      .optionallyWith(
        smsAuthenticationMessage.map(value =>
          SmsVerificationMessageType.unwrap(value): java.lang.String
        )
      )(_.smsAuthenticationMessage)
      .optionallyWith(
        userAttributeUpdateSettings.map(value => value.buildAwsValue())
      )(_.userAttributeUpdateSettings)
      .optionallyWith(mfaConfiguration.map(value => value.unwrap))(
        _.mfaConfiguration
      )
      .optionallyWith(deviceConfiguration.map(value => value.buildAwsValue()))(
        _.deviceConfiguration
      )
      .optionallyWith(
        estimatedNumberOfUsers.map(value => IntegerType.unwrap(value): Integer)
      )(_.estimatedNumberOfUsers)
      .optionallyWith(emailConfiguration.map(value => value.buildAwsValue()))(
        _.emailConfiguration
      )
      .optionallyWith(smsConfiguration.map(value => value.buildAwsValue()))(
        _.smsConfiguration
      )
      .optionallyWith(
        userPoolTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKeysType.unwrap(key): java.lang.String) -> (TagValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.userPoolTags)
      .optionallyWith(
        smsConfigurationFailure.map(value => value: java.lang.String)
      )(_.smsConfigurationFailure)
      .optionallyWith(
        emailConfigurationFailure.map(value => value: java.lang.String)
      )(_.emailConfigurationFailure)
      .optionallyWith(
        domain.map(value => DomainType.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        customDomain.map(value => DomainType.unwrap(value): java.lang.String)
      )(_.customDomain)
      .optionallyWith(
        adminCreateUserConfig.map(value => value.buildAwsValue())
      )(_.adminCreateUserConfig)
      .optionallyWith(userPoolAddOns.map(value => value.buildAwsValue()))(
        _.userPoolAddOns
      )
      .optionallyWith(
        usernameConfiguration.map(value => value.buildAwsValue())
      )(_.usernameConfiguration)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        accountRecoverySetting.map(value => value.buildAwsValue())
      )(_.accountRecoverySetting)
      .build()
  }
  def asReadOnly: zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UserPoolType.wrap(buildAwsValue())
}
object UserPoolType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.UserPoolType =
      zio.aws.cognitoidentityprovider.model.UserPoolType(
        id.map(value => value),
        name.map(value => value),
        policies.map(value => value.asEditable),
        deletionProtection.map(value => value),
        lambdaConfig.map(value => value.asEditable),
        status.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value),
        schemaAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoVerifiedAttributes.map(value => value),
        aliasAttributes.map(value => value),
        usernameAttributes.map(value => value),
        smsVerificationMessage.map(value => value),
        emailVerificationMessage.map(value => value),
        emailVerificationSubject.map(value => value),
        verificationMessageTemplate.map(value => value.asEditable),
        smsAuthenticationMessage.map(value => value),
        userAttributeUpdateSettings.map(value => value.asEditable),
        mfaConfiguration.map(value => value),
        deviceConfiguration.map(value => value.asEditable),
        estimatedNumberOfUsers.map(value => value),
        emailConfiguration.map(value => value.asEditable),
        smsConfiguration.map(value => value.asEditable),
        userPoolTags.map(value => value),
        smsConfigurationFailure.map(value => value),
        emailConfigurationFailure.map(value => value),
        domain.map(value => value),
        customDomain.map(value => value),
        adminCreateUserConfig.map(value => value.asEditable),
        userPoolAddOns.map(value => value.asEditable),
        usernameConfiguration.map(value => value.asEditable),
        arn.map(value => value),
        accountRecoverySetting.map(value => value.asEditable)
      )
    def id: Optional[UserPoolIdType]
    def name: Optional[UserPoolNameType]
    def policies: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ]
    def deletionProtection
        : Optional[zio.aws.cognitoidentityprovider.model.DeletionProtectionType]
    def lambdaConfig: Optional[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ]
    def status: Optional[zio.aws.cognitoidentityprovider.model.StatusType]
    def lastModifiedDate: Optional[DateType]
    def creationDate: Optional[DateType]
    def schemaAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly]
    ]
    def autoVerifiedAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ]
    def aliasAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.AliasAttributeType]
    ]
    def usernameAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.UsernameAttributeType]
    ]
    def smsVerificationMessage: Optional[SmsVerificationMessageType]
    def emailVerificationMessage: Optional[EmailVerificationMessageType]
    def emailVerificationSubject: Optional[EmailVerificationSubjectType]
    def verificationMessageTemplate: Optional[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ]
    def smsAuthenticationMessage: Optional[SmsVerificationMessageType]
    def userAttributeUpdateSettings: Optional[
      zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.ReadOnly
    ]
    def mfaConfiguration
        : Optional[zio.aws.cognitoidentityprovider.model.UserPoolMfaType]
    def deviceConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ]
    def estimatedNumberOfUsers: Optional[IntegerType]
    def emailConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ]
    def smsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ]
    def userPoolTags: Optional[Map[TagKeysType, TagValueType]]
    def smsConfigurationFailure: Optional[StringType]
    def emailConfigurationFailure: Optional[StringType]
    def domain: Optional[DomainType]
    def customDomain: Optional[DomainType]
    def adminCreateUserConfig: Optional[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ]
    def userPoolAddOns: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ]
    def usernameConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType.ReadOnly
    ]
    def arn: Optional[ArnType]
    def accountRecoverySetting: Optional[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ]
    def getId: ZIO[Any, AwsError, UserPoolIdType] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, UserPoolNameType] =
      AwsError.unwrapOptionField("name", name)
    def getPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ] = AwsError.unwrapOptionField("policies", policies)
    def getDeletionProtection: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeletionProtectionType
    ] = AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getLambdaConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaConfig", lambdaConfig)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cognitoidentityprovider.model.StatusType] =
      AwsError.unwrapOptionField("status", status)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getSchemaAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly
    ]] = AwsError.unwrapOptionField("schemaAttributes", schemaAttributes)
    def getAutoVerifiedAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.VerifiedAttributeType
    ]] = AwsError.unwrapOptionField(
      "autoVerifiedAttributes",
      autoVerifiedAttributes
    )
    def getAliasAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.AliasAttributeType
    ]] = AwsError.unwrapOptionField("aliasAttributes", aliasAttributes)
    def getUsernameAttributes: ZIO[Any, AwsError, List[
      zio.aws.cognitoidentityprovider.model.UsernameAttributeType
    ]] = AwsError.unwrapOptionField("usernameAttributes", usernameAttributes)
    def getSmsVerificationMessage
        : ZIO[Any, AwsError, SmsVerificationMessageType] = AwsError
      .unwrapOptionField("smsVerificationMessage", smsVerificationMessage)
    def getEmailVerificationMessage
        : ZIO[Any, AwsError, EmailVerificationMessageType] = AwsError
      .unwrapOptionField("emailVerificationMessage", emailVerificationMessage)
    def getEmailVerificationSubject
        : ZIO[Any, AwsError, EmailVerificationSubjectType] = AwsError
      .unwrapOptionField("emailVerificationSubject", emailVerificationSubject)
    def getVerificationMessageTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verificationMessageTemplate",
      verificationMessageTemplate
    )
    def getSmsAuthenticationMessage
        : ZIO[Any, AwsError, SmsVerificationMessageType] = AwsError
      .unwrapOptionField("smsAuthenticationMessage", smsAuthenticationMessage)
    def getUserAttributeUpdateSettings: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "userAttributeUpdateSettings",
      userAttributeUpdateSettings
    )
    def getMfaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolMfaType
    ] = AwsError.unwrapOptionField("mfaConfiguration", mfaConfiguration)
    def getDeviceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("deviceConfiguration", deviceConfiguration)
    def getEstimatedNumberOfUsers: ZIO[Any, AwsError, IntegerType] = AwsError
      .unwrapOptionField("estimatedNumberOfUsers", estimatedNumberOfUsers)
    def getEmailConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("emailConfiguration", emailConfiguration)
    def getSmsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ] = AwsError.unwrapOptionField("smsConfiguration", smsConfiguration)
    def getUserPoolTags: ZIO[Any, AwsError, Map[TagKeysType, TagValueType]] =
      AwsError.unwrapOptionField("userPoolTags", userPoolTags)
    def getSmsConfigurationFailure: ZIO[Any, AwsError, StringType] = AwsError
      .unwrapOptionField("smsConfigurationFailure", smsConfigurationFailure)
    def getEmailConfigurationFailure: ZIO[Any, AwsError, StringType] = AwsError
      .unwrapOptionField("emailConfigurationFailure", emailConfigurationFailure)
    def getDomain: ZIO[Any, AwsError, DomainType] =
      AwsError.unwrapOptionField("domain", domain)
    def getCustomDomain: ZIO[Any, AwsError, DomainType] =
      AwsError.unwrapOptionField("customDomain", customDomain)
    def getAdminCreateUserConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ] =
      AwsError.unwrapOptionField("adminCreateUserConfig", adminCreateUserConfig)
    def getUserPoolAddOns: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ] = AwsError.unwrapOptionField("userPoolAddOns", userPoolAddOns)
    def getUsernameConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType.ReadOnly
    ] =
      AwsError.unwrapOptionField("usernameConfiguration", usernameConfiguration)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getAccountRecoverySetting: ZIO[
      Any,
      AwsError,
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountRecoverySetting",
      accountRecoverySetting
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType
  ) extends zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly {
    override val id: Optional[UserPoolIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolIdType(value)
      )
    override val name: Optional[UserPoolNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.UserPoolNameType(value)
      )
    override val policies: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.policies())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolPolicyType.wrap(value)
      )
    override val deletionProtection: Optional[
      zio.aws.cognitoidentityprovider.model.DeletionProtectionType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionProtection())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.DeletionProtectionType.wrap(value)
      )
    override val lambdaConfig: Optional[
      zio.aws.cognitoidentityprovider.model.LambdaConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.LambdaConfigType.wrap(value)
      )
    override val status
        : Optional[zio.aws.cognitoidentityprovider.model.StatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.StatusType.wrap(value)
        )
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DateType(value)
      )
    override val schemaAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.SchemaAttributeType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.SchemaAttributeType.wrap(item)
        }.toList
      )
    override val autoVerifiedAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.VerifiedAttributeType]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.autoVerifiedAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.VerifiedAttributeType.wrap(item)
        }.toList
      )
    override val aliasAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.AliasAttributeType]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.aliasAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.AliasAttributeType.wrap(item)
        }.toList
      )
    override val usernameAttributes: Optional[
      List[zio.aws.cognitoidentityprovider.model.UsernameAttributeType]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.usernameAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitoidentityprovider.model.UsernameAttributeType.wrap(item)
        }.toList
      )
    override val smsVerificationMessage: Optional[SmsVerificationMessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smsVerificationMessage())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .SmsVerificationMessageType(value)
        )
    override val emailVerificationMessage
        : Optional[EmailVerificationMessageType] = zio.aws.core.internal
      .optionalFromNullable(impl.emailVerificationMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationMessageType(value)
      )
    override val emailVerificationSubject
        : Optional[EmailVerificationSubjectType] = zio.aws.core.internal
      .optionalFromNullable(impl.emailVerificationSubject())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .EmailVerificationSubjectType(value)
      )
    override val verificationMessageTemplate: Optional[
      zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.verificationMessageTemplate())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.VerificationMessageTemplateType
          .wrap(value)
      )
    override val smsAuthenticationMessage
        : Optional[SmsVerificationMessageType] = zio.aws.core.internal
      .optionalFromNullable(impl.smsAuthenticationMessage())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .SmsVerificationMessageType(value)
      )
    override val userAttributeUpdateSettings: Optional[
      zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userAttributeUpdateSettings())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserAttributeUpdateSettingsType
          .wrap(value)
      )
    override val mfaConfiguration
        : Optional[zio.aws.cognitoidentityprovider.model.UserPoolMfaType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mfaConfiguration())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.UserPoolMfaType.wrap(value)
        )
    override val deviceConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.DeviceConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.DeviceConfigurationType
          .wrap(value)
      )
    override val estimatedNumberOfUsers: Optional[IntegerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedNumberOfUsers())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives.IntegerType(value)
        )
    override val emailConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.EmailConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.emailConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.EmailConfigurationType.wrap(value)
      )
    override val smsConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.SmsConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.smsConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.SmsConfigurationType.wrap(value)
      )
    override val userPoolTags: Optional[Map[TagKeysType, TagValueType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userPoolTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitoidentityprovider.model.primitives.TagKeysType(
                key
              ) -> zio.aws.cognitoidentityprovider.model.primitives
                .TagValueType(value)
            })
            .toMap
        )
    override val smsConfigurationFailure: Optional[StringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smsConfigurationFailure())
        .map(value => value: StringType)
    override val emailConfigurationFailure: Optional[StringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailConfigurationFailure())
        .map(value => value: StringType)
    override val domain: Optional[DomainType] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DomainType(value)
      )
    override val customDomain: Optional[DomainType] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomain())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.DomainType(value)
      )
    override val adminCreateUserConfig: Optional[
      zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.adminCreateUserConfig())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AdminCreateUserConfigType
          .wrap(value)
      )
    override val userPoolAddOns: Optional[
      zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolAddOns())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UserPoolAddOnsType.wrap(value)
      )
    override val usernameConfiguration: Optional[
      zio.aws.cognitoidentityprovider.model.UsernameConfigurationType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.usernameConfiguration())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.UsernameConfigurationType
          .wrap(value)
      )
    override val arn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives.ArnType(value)
      )
    override val accountRecoverySetting: Optional[
      zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountRecoverySetting())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.AccountRecoverySettingType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType
  ): zio.aws.cognitoidentityprovider.model.UserPoolType.ReadOnly = new Wrapper(
    impl
  )
}
