package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  PoolQueryLimitType,
  PaginationKeyType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUserPoolsRequest(
    nextToken: Optional[PaginationKeyType] = Optional.Absent,
    maxResults: PoolQueryLimitType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest = {
    import ListUserPoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value =>
          PaginationKeyType.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .maxResults(PoolQueryLimitType.unwrap(maxResults): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUserPoolsRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUserPoolsRequest
      .wrap(buildAwsValue())
}
object ListUserPoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitoidentityprovider.model.ListUserPoolsRequest =
      zio.aws.cognitoidentityprovider.model
        .ListUserPoolsRequest(nextToken.map(value => value), maxResults)
    def nextToken: Optional[PaginationKeyType]
    def maxResults: PoolQueryLimitType
    def getNextToken: ZIO[Any, AwsError, PaginationKeyType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, Nothing, PoolQueryLimitType] =
      ZIO.succeed(maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListUserPoolsRequest.ReadOnly {
    override val nextToken: Optional[PaginationKeyType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.cognitoidentityprovider.model.primitives
          .PaginationKeyType(value)
      )
    override val maxResults: PoolQueryLimitType =
      zio.aws.cognitoidentityprovider.model.primitives
        .PoolQueryLimitType(impl.maxResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest
  ): zio.aws.cognitoidentityprovider.model.ListUserPoolsRequest.ReadOnly =
    new Wrapper(impl)
}
