package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait DeletionProtectionType {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.DeletionProtectionType
}
object DeletionProtectionType {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.DeletionProtectionType
  ): zio.aws.cognitoidentityprovider.model.DeletionProtectionType =
    value match {
      case software.amazon.awssdk.services.cognitoidentityprovider.model.DeletionProtectionType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.DeletionProtectionType.ACTIVE =>
        val r = ACTIVE
        r
      case software.amazon.awssdk.services.cognitoidentityprovider.model.DeletionProtectionType.INACTIVE =>
        val r = INACTIVE
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.DeletionProtectionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DeletionProtectionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeletionProtectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE
      extends zio.aws.cognitoidentityprovider.model.DeletionProtectionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DeletionProtectionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeletionProtectionType.ACTIVE
  }
  case object INACTIVE
      extends zio.aws.cognitoidentityprovider.model.DeletionProtectionType {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.DeletionProtectionType =
      software.amazon.awssdk.services.cognitoidentityprovider.model.DeletionProtectionType.INACTIVE
  }
}
