package zio.aws.cognitoidentityprovider.model
import scala.jdk.CollectionConverters._
sealed trait ChallengeName {
  def unwrap: software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName
}
object ChallengeName {
  def wrap(
      value: software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName
  ): zio.aws.cognitoidentityprovider.model.ChallengeName = value match {
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName.PASSWORD =>
      val r = Password
      r
    case software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName.MFA =>
      val r = Mfa
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitoidentityprovider.model.ChallengeName {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName.UNKNOWN_TO_SDK_VERSION
  }
  case object Password
      extends zio.aws.cognitoidentityprovider.model.ChallengeName {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName.PASSWORD
  }
  case object Mfa extends zio.aws.cognitoidentityprovider.model.ChallengeName {
    override def unwrap
        : software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName =
      software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName.MFA
  }
}
