package zio.aws.cognitoidentityprovider.model
import zio.aws.cognitoidentityprovider.model.primitives.{
  PaginationKeyType,
  PoolQueryLimitType,
  UserPoolIdType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUserImportJobsRequest(
    userPoolId: UserPoolIdType,
    maxResults: PoolQueryLimitType,
    paginationToken: Optional[PaginationKeyType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest = {
    import ListUserImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest
      .builder()
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .maxResults(PoolQueryLimitType.unwrap(maxResults): Integer)
      .optionallyWith(
        paginationToken.map(value =>
          PaginationKeyType.unwrap(value): java.lang.String
        )
      )(_.paginationToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListUserImportJobsRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListUserImportJobsRequest
      .wrap(buildAwsValue())
}
object ListUserImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListUserImportJobsRequest =
      zio.aws.cognitoidentityprovider.model.ListUserImportJobsRequest(
        userPoolId,
        maxResults,
        paginationToken.map(value => value)
      )
    def userPoolId: UserPoolIdType
    def maxResults: PoolQueryLimitType
    def paginationToken: Optional[PaginationKeyType]
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getMaxResults: ZIO[Any, Nothing, PoolQueryLimitType] =
      ZIO.succeed(maxResults)
    def getPaginationToken: ZIO[Any, AwsError, PaginationKeyType] =
      AwsError.unwrapOptionField("paginationToken", paginationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListUserImportJobsRequest.ReadOnly {
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val maxResults: PoolQueryLimitType =
      zio.aws.cognitoidentityprovider.model.primitives
        .PoolQueryLimitType(impl.maxResults())
    override val paginationToken: Optional[PaginationKeyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paginationToken())
        .map(value =>
          zio.aws.cognitoidentityprovider.model.primitives
            .PaginationKeyType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest
  ): zio.aws.cognitoidentityprovider.model.ListUserImportJobsRequest.ReadOnly =
    new Wrapper(impl)
}
