package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.{
  UserPoolIdType,
  DomainType
}
import scala.jdk.CollectionConverters._
final case class UpdateUserPoolDomainRequest(
    domain: DomainType,
    userPoolId: UserPoolIdType,
    customDomainConfig: zio.aws.cognitoidentityprovider.model.CustomDomainConfigType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest = {
    import UpdateUserPoolDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest
      .builder()
      .domain(DomainType.unwrap(domain): java.lang.String)
      .userPoolId(UserPoolIdType.unwrap(userPoolId): java.lang.String)
      .customDomainConfig(customDomainConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainRequest
      .wrap(buildAwsValue())
}
object UpdateUserPoolDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainRequest =
      zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainRequest(
        domain,
        userPoolId,
        customDomainConfig.asEditable
      )
    def domain: DomainType
    def userPoolId: UserPoolIdType
    def customDomainConfig
        : zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly
    def getDomain: ZIO[Any, Nothing, DomainType] = ZIO.succeed(domain)
    def getUserPoolId: ZIO[Any, Nothing, UserPoolIdType] =
      ZIO.succeed(userPoolId)
    def getCustomDomainConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly
    ] = ZIO.succeed(customDomainConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest
  ) extends zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainRequest.ReadOnly {
    override val domain: DomainType =
      zio.aws.cognitoidentityprovider.model.primitives.DomainType(impl.domain())
    override val userPoolId: UserPoolIdType =
      zio.aws.cognitoidentityprovider.model.primitives
        .UserPoolIdType(impl.userPoolId())
    override val customDomainConfig
        : zio.aws.cognitoidentityprovider.model.CustomDomainConfigType.ReadOnly =
      zio.aws.cognitoidentityprovider.model.CustomDomainConfigType
        .wrap(impl.customDomainConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest
  ): zio.aws.cognitoidentityprovider.model.UpdateUserPoolDomainRequest.ReadOnly =
    new Wrapper(impl)
}
