package zio.aws.cognitoidentityprovider.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cognitoidentityprovider.model.primitives.ArnType
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: ArnType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ArnType.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitoidentityprovider.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.cognitoidentityprovider.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitoidentityprovider.model.ListTagsForResourceRequest =
      zio.aws.cognitoidentityprovider.model
        .ListTagsForResourceRequest(resourceArn)
    def resourceArn: ArnType
    def getResourceArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest
  ) extends zio.aws.cognitoidentityprovider.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ArnType =
      zio.aws.cognitoidentityprovider.model.primitives
        .ArnType(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest
  ): zio.aws.cognitoidentityprovider.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
